/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the user-based subscription products for a specific user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductUserSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductUserSummary.Builder, ProductUserSummary> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(ProductUserSummary::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(ProductUserSummary::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(ProductUserSummary::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProductUserSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PRODUCT_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductUserArn").getter(getter(ProductUserSummary::productUserArn))
            .setter(setter(Builder::productUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductUserArn").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProductUserSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ProductUserSummary::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> SUBSCRIPTION_START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionStartDate").getter(getter(ProductUserSummary::subscriptionStartDate))
            .setter(setter(Builder::subscriptionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStartDate").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionEndDate").getter(getter(ProductUserSummary::subscriptionEndDate))
            .setter(setter(Builder::subscriptionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionEndDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PRODUCT_FIELD,
            IDENTITY_PROVIDER_FIELD, STATUS_FIELD, PRODUCT_USER_ARN_FIELD, STATUS_MESSAGE_FIELD, DOMAIN_FIELD,
            SUBSCRIPTION_START_DATE_FIELD, SUBSCRIPTION_END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String product;

    private final IdentityProvider identityProvider;

    private final String status;

    private final String productUserArn;

    private final String statusMessage;

    private final String domain;

    private final String subscriptionStartDate;

    private final String subscriptionEndDate;

    private ProductUserSummary(BuilderImpl builder) {
        this.username = builder.username;
        this.product = builder.product;
        this.identityProvider = builder.identityProvider;
        this.status = builder.status;
        this.productUserArn = builder.productUserArn;
        this.statusMessage = builder.statusMessage;
        this.domain = builder.domain;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.subscriptionEndDate = builder.subscriptionEndDate;
    }

    /**
     * <p>
     * The user name from the identity provider for this product user.
     * </p>
     * 
     * @return The user name from the identity provider for this product user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The name of the user-based subscription product.
     * </p>
     * 
     * @return The name of the user-based subscription product.
     */
    public final String product() {
        return product;
    }

    /**
     * <p>
     * An object that specifies details for the identity provider.
     * </p>
     * 
     * @return An object that specifies details for the identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The status of a product for this user.
     * </p>
     * 
     * @return The status of a product for this user.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this product user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this product user.
     */
    public final String productUserArn() {
        return productUserArn;
    }

    /**
     * <p>
     * The status message for a product for this user.
     * </p>
     * 
     * @return The status message for a product for this user.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The domain name of the Active Directory that contains the user information for the product subscription.
     * </p>
     * 
     * @return The domain name of the Active Directory that contains the user information for the product subscription.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The start date of a subscription.
     * </p>
     * 
     * @return The start date of a subscription.
     */
    public final String subscriptionStartDate() {
        return subscriptionStartDate;
    }

    /**
     * <p>
     * The end date of a subscription.
     * </p>
     * 
     * @return The end date of a subscription.
     */
    public final String subscriptionEndDate() {
        return subscriptionEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(productUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductUserSummary)) {
            return false;
        }
        ProductUserSummary other = (ProductUserSummary) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(product(), other.product())
                && Objects.equals(identityProvider(), other.identityProvider()) && Objects.equals(status(), other.status())
                && Objects.equals(productUserArn(), other.productUserArn())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(domain(), other.domain())
                && Objects.equals(subscriptionStartDate(), other.subscriptionStartDate())
                && Objects.equals(subscriptionEndDate(), other.subscriptionEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductUserSummary").add("Username", username()).add("Product", product())
                .add("IdentityProvider", identityProvider()).add("Status", status()).add("ProductUserArn", productUserArn())
                .add("StatusMessage", statusMessage()).add("Domain", domain())
                .add("SubscriptionStartDate", subscriptionStartDate()).add("SubscriptionEndDate", subscriptionEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ProductUserArn":
            return Optional.ofNullable(clazz.cast(productUserArn()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "SubscriptionStartDate":
            return Optional.ofNullable(clazz.cast(subscriptionStartDate()));
        case "SubscriptionEndDate":
            return Optional.ofNullable(clazz.cast(subscriptionEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("Product", PRODUCT_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProductUserArn", PRODUCT_USER_ARN_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("SubscriptionStartDate", SUBSCRIPTION_START_DATE_FIELD);
        map.put("SubscriptionEndDate", SUBSCRIPTION_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductUserSummary, T> g) {
        return obj -> g.apply((ProductUserSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductUserSummary> {
        /**
         * <p>
         * The user name from the identity provider for this product user.
         * </p>
         * 
         * @param username
         *        The user name from the identity provider for this product user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The name of the user-based subscription product.
         * </p>
         * 
         * @param product
         *        The name of the user-based subscription product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * 
         * @param identityProvider
         *        An object that specifies details for the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The status of a product for this user.
         * </p>
         * 
         * @param status
         *        The status of a product for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for this product user.
         * </p>
         * 
         * @param productUserArn
         *        The Amazon Resource Name (ARN) for this product user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUserArn(String productUserArn);

        /**
         * <p>
         * The status message for a product for this user.
         * </p>
         * 
         * @param statusMessage
         *        The status message for a product for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The domain name of the Active Directory that contains the user information for the product subscription.
         * </p>
         * 
         * @param domain
         *        The domain name of the Active Directory that contains the user information for the product
         *        subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The start date of a subscription.
         * </p>
         * 
         * @param subscriptionStartDate
         *        The start date of a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionStartDate(String subscriptionStartDate);

        /**
         * <p>
         * The end date of a subscription.
         * </p>
         * 
         * @param subscriptionEndDate
         *        The end date of a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionEndDate(String subscriptionEndDate);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String product;

        private IdentityProvider identityProvider;

        private String status;

        private String productUserArn;

        private String statusMessage;

        private String domain;

        private String subscriptionStartDate;

        private String subscriptionEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductUserSummary model) {
            username(model.username);
            product(model.product);
            identityProvider(model.identityProvider);
            status(model.status);
            productUserArn(model.productUserArn);
            statusMessage(model.statusMessage);
            domain(model.domain);
            subscriptionStartDate(model.subscriptionStartDate);
            subscriptionEndDate(model.subscriptionEndDate);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getProductUserArn() {
            return productUserArn;
        }

        public final void setProductUserArn(String productUserArn) {
            this.productUserArn = productUserArn;
        }

        @Override
        public final Builder productUserArn(String productUserArn) {
            this.productUserArn = productUserArn;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getSubscriptionStartDate() {
            return subscriptionStartDate;
        }

        public final void setSubscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final String getSubscriptionEndDate() {
            return subscriptionEndDate;
        }

        public final void setSubscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
        }

        @Override
        public final Builder subscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        @Override
        public ProductUserSummary build() {
            return new ProductUserSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
