/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLicenseServerEndpointRequest extends LicenseManagerUserSubscriptionsRequest implements
        ToCopyableBuilder<DeleteLicenseServerEndpointRequest.Builder, DeleteLicenseServerEndpointRequest> {
    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseServerEndpointArn").getter(getter(DeleteLicenseServerEndpointRequest::licenseServerEndpointArn))
            .setter(setter(Builder::licenseServerEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointArn").build())
            .build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerType").getter(getter(DeleteLicenseServerEndpointRequest::serverTypeAsString))
            .setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_SERVER_ENDPOINT_ARN_FIELD, SERVER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String licenseServerEndpointArn;

    private final String serverType;

    private DeleteLicenseServerEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.licenseServerEndpointArn = builder.licenseServerEndpointArn;
        this.serverType = builder.serverType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the <code>LicenseServerEndpoint</code> resource to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the <code>LicenseServerEndpoint</code> resource to delete.
     */
    public final String licenseServerEndpointArn() {
        return licenseServerEndpointArn;
    }

    /**
     * <p>
     * The type of License Server that the delete request refers to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of License Server that the delete request refers to.
     * @see ServerType
     */
    public final ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of License Server that the delete request refers to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of License Server that the delete request refers to.
     * @see ServerType
     */
    public final String serverTypeAsString() {
        return serverType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLicenseServerEndpointRequest)) {
            return false;
        }
        DeleteLicenseServerEndpointRequest other = (DeleteLicenseServerEndpointRequest) obj;
        return Objects.equals(licenseServerEndpointArn(), other.licenseServerEndpointArn())
                && Objects.equals(serverTypeAsString(), other.serverTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLicenseServerEndpointRequest").add("LicenseServerEndpointArn", licenseServerEndpointArn())
                .add("ServerType", serverTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseServerEndpointArn":
            return Optional.ofNullable(clazz.cast(licenseServerEndpointArn()));
        case "ServerType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicenseServerEndpointArn", LICENSE_SERVER_ENDPOINT_ARN_FIELD);
        map.put("ServerType", SERVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLicenseServerEndpointRequest, T> g) {
        return obj -> g.apply((DeleteLicenseServerEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerUserSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLicenseServerEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the <code>LicenseServerEndpoint</code> resource to delete.
         * </p>
         * 
         * @param licenseServerEndpointArn
         *        The Amazon Resource Name (ARN) that identifies the <code>LicenseServerEndpoint</code> resource to
         *        delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpointArn(String licenseServerEndpointArn);

        /**
         * <p>
         * The type of License Server that the delete request refers to.
         * </p>
         * 
         * @param serverType
         *        The type of License Server that the delete request refers to.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of License Server that the delete request refers to.
         * </p>
         * 
         * @param serverType
         *        The type of License Server that the delete request refers to.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsRequest.BuilderImpl implements Builder {
        private String licenseServerEndpointArn;

        private String serverType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLicenseServerEndpointRequest model) {
            super(model);
            licenseServerEndpointArn(model.licenseServerEndpointArn);
            serverType(model.serverType);
        }

        public final String getLicenseServerEndpointArn() {
            return licenseServerEndpointArn;
        }

        public final void setLicenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
        }

        @Override
        public final Builder licenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLicenseServerEndpointRequest build() {
            return new DeleteLicenseServerEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
