/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 instance providing user-based subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSummary implements SdkPojo, Serializable, ToCopyableBuilder<InstanceSummary.Builder, InstanceSummary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceSummary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InstanceSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Products")
            .getter(getter(InstanceSummary::products))
            .setter(setter(Builder::products))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Products").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_STATUS_CHECK_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastStatusCheckDate").getter(getter(InstanceSummary::lastStatusCheckDate))
            .setter(setter(Builder::lastStatusCheckDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusCheckDate").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(InstanceSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(InstanceSummary::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(InstanceSummary::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            STATUS_FIELD, PRODUCTS_FIELD, LAST_STATUS_CHECK_DATE_FIELD, STATUS_MESSAGE_FIELD, OWNER_ACCOUNT_ID_FIELD,
            IDENTITY_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String status;

    private final List<String> products;

    private final String lastStatusCheckDate;

    private final String statusMessage;

    private final String ownerAccountId;

    private final IdentityProvider identityProvider;

    private InstanceSummary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.products = builder.products;
        this.lastStatusCheckDate = builder.lastStatusCheckDate;
        this.statusMessage = builder.statusMessage;
        this.ownerAccountId = builder.ownerAccountId;
        this.identityProvider = builder.identityProvider;
    }

    /**
     * <p>
     * The ID of the EC2 instance, which provides user-based subscriptions.
     * </p>
     * 
     * @return The ID of the EC2 instance, which provides user-based subscriptions.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The status of an EC2 instance resource.
     * </p>
     * 
     * @return The status of an EC2 instance resource.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Products property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProducts() {
        return products != null && !(products instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of provided user-based subscription products.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProducts} method.
     * </p>
     * 
     * @return A list of provided user-based subscription products.
     */
    public final List<String> products() {
        return products;
    }

    /**
     * <p>
     * The date of the last status check.
     * </p>
     * 
     * @return The date of the last status check.
     */
    public final String lastStatusCheckDate() {
        return lastStatusCheckDate;
    }

    /**
     * <p>
     * The status message for an EC2 instance.
     * </p>
     * 
     * @return The status message for an EC2 instance.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The AWS Account ID of the owner of this resource.
     * </p>
     * 
     * @return The AWS Account ID of the owner of this resource.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The <code>IdentityProvider</code> resource specifies details about the identity provider.
     * </p>
     * 
     * @return The <code>IdentityProvider</code> resource specifies details about the identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasProducts() ? products() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusCheckDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(status(), other.status())
                && hasProducts() == other.hasProducts() && Objects.equals(products(), other.products())
                && Objects.equals(lastStatusCheckDate(), other.lastStatusCheckDate())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(identityProvider(), other.identityProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSummary").add("InstanceId", instanceId()).add("Status", status())
                .add("Products", hasProducts() ? products() : null).add("LastStatusCheckDate", lastStatusCheckDate())
                .add("StatusMessage", statusMessage()).add("OwnerAccountId", ownerAccountId())
                .add("IdentityProvider", identityProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Products":
            return Optional.ofNullable(clazz.cast(products()));
        case "LastStatusCheckDate":
            return Optional.ofNullable(clazz.cast(lastStatusCheckDate()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Products", PRODUCTS_FIELD);
        map.put("LastStatusCheckDate", LAST_STATUS_CHECK_DATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSummary> {
        /**
         * <p>
         * The ID of the EC2 instance, which provides user-based subscriptions.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance, which provides user-based subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The status of an EC2 instance resource.
         * </p>
         * 
         * @param status
         *        The status of an EC2 instance resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A list of provided user-based subscription products.
         * </p>
         * 
         * @param products
         *        A list of provided user-based subscription products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder products(Collection<String> products);

        /**
         * <p>
         * A list of provided user-based subscription products.
         * </p>
         * 
         * @param products
         *        A list of provided user-based subscription products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder products(String... products);

        /**
         * <p>
         * The date of the last status check.
         * </p>
         * 
         * @param lastStatusCheckDate
         *        The date of the last status check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusCheckDate(String lastStatusCheckDate);

        /**
         * <p>
         * The status message for an EC2 instance.
         * </p>
         * 
         * @param statusMessage
         *        The status message for an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The AWS Account ID of the owner of this resource.
         * </p>
         * 
         * @param ownerAccountId
         *        The AWS Account ID of the owner of this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * </p>
         * 
         * @param identityProvider
         *        The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String status;

        private List<String> products = DefaultSdkAutoConstructList.getInstance();

        private String lastStatusCheckDate;

        private String statusMessage;

        private String ownerAccountId;

        private IdentityProvider identityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            instanceId(model.instanceId);
            status(model.status);
            products(model.products);
            lastStatusCheckDate(model.lastStatusCheckDate);
            statusMessage(model.statusMessage);
            ownerAccountId(model.ownerAccountId);
            identityProvider(model.identityProvider);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getProducts() {
            if (products instanceof SdkAutoConstructList) {
                return null;
            }
            return products;
        }

        public final void setProducts(Collection<String> products) {
            this.products = StringListCopier.copy(products);
        }

        @Override
        public final Builder products(Collection<String> products) {
            this.products = StringListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(String... products) {
            products(Arrays.asList(products));
            return this;
        }

        public final String getLastStatusCheckDate() {
            return lastStatusCheckDate;
        }

        public final void setLastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
        }

        @Override
        public final Builder lastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        @Override
        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
