/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a network endpoint for a Remote Desktop Services (RDS) license server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseServerEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseServerEndpoint.Builder, LicenseServerEndpoint> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderArn").getter(getter(LicenseServerEndpoint::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build())
            .build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerType").getter(getter(LicenseServerEndpoint::serverTypeAsString))
            .setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerType").build()).build();

    private static final SdkField<ServerEndpoint> SERVER_ENDPOINT_FIELD = SdkField
            .<ServerEndpoint> builder(MarshallingType.SDK_POJO).memberName("ServerEndpoint")
            .getter(getter(LicenseServerEndpoint::serverEndpoint)).setter(setter(Builder::serverEndpoint))
            .constructor(ServerEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerEndpoint").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(LicenseServerEndpoint::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseServerEndpointId").getter(getter(LicenseServerEndpoint::licenseServerEndpointId))
            .setter(setter(Builder::licenseServerEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointId").build())
            .build();

    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseServerEndpointArn").getter(getter(LicenseServerEndpoint::licenseServerEndpointArn))
            .setter(setter(Builder::licenseServerEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointArn").build())
            .build();

    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseServerEndpointProvisioningStatus")
            .getter(getter(LicenseServerEndpoint::licenseServerEndpointProvisioningStatusAsString))
            .setter(setter(Builder::licenseServerEndpointProvisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LicenseServerEndpointProvisioningStatus").build()).build();

    private static final SdkField<List<LicenseServer>> LICENSE_SERVERS_FIELD = SdkField
            .<List<LicenseServer>> builder(MarshallingType.LIST)
            .memberName("LicenseServers")
            .getter(getter(LicenseServerEndpoint::licenseServers))
            .setter(setter(Builder::licenseServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(LicenseServerEndpoint::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD,
            SERVER_TYPE_FIELD, SERVER_ENDPOINT_FIELD, STATUS_MESSAGE_FIELD, LICENSE_SERVER_ENDPOINT_ID_FIELD,
            LICENSE_SERVER_ENDPOINT_ARN_FIELD, LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD, LICENSE_SERVERS_FIELD,
            CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identityProviderArn;

    private final String serverType;

    private final ServerEndpoint serverEndpoint;

    private final String statusMessage;

    private final String licenseServerEndpointId;

    private final String licenseServerEndpointArn;

    private final String licenseServerEndpointProvisioningStatus;

    private final List<LicenseServer> licenseServers;

    private final Instant creationTime;

    private LicenseServerEndpoint(BuilderImpl builder) {
        this.identityProviderArn = builder.identityProviderArn;
        this.serverType = builder.serverType;
        this.serverEndpoint = builder.serverEndpoint;
        this.statusMessage = builder.statusMessage;
        this.licenseServerEndpointId = builder.licenseServerEndpointId;
        this.licenseServerEndpointArn = builder.licenseServerEndpointArn;
        this.licenseServerEndpointProvisioningStatus = builder.licenseServerEndpointProvisioningStatus;
        this.licenseServers = builder.licenseServers;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity provider that's associated with the RDS license server endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the identity provider that's associated with the RDS license server
     *         endpoint.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * <p>
     * The type of license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of license server.
     * @see ServerType
     */
    public final ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of license server.
     * @see ServerType
     */
    public final String serverTypeAsString() {
        return serverType;
    }

    /**
     * <p>
     * The <code>ServerEndpoint</code> resource contains the network address of the RDS license server endpoint.
     * </p>
     * 
     * @return The <code>ServerEndpoint</code> resource contains the network address of the RDS license server endpoint.
     */
    public final ServerEndpoint serverEndpoint() {
        return serverEndpoint;
    }

    /**
     * <p>
     * The message associated with the provisioning status, if there is one.
     * </p>
     * 
     * @return The message associated with the provisioning status, if there is one.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The ID of the license server endpoint.
     * </p>
     * 
     * @return The ID of the license server endpoint.
     */
    public final String licenseServerEndpointId() {
        return licenseServerEndpointId;
    }

    /**
     * <p>
     * The ARN of the <code>ServerEndpoint</code> resource for the RDS license server.
     * </p>
     * 
     * @return The ARN of the <code>ServerEndpoint</code> resource for the RDS license server.
     */
    public final String licenseServerEndpointArn() {
        return licenseServerEndpointArn;
    }

    /**
     * <p>
     * The current state of the provisioning process for the RDS license server endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseServerEndpointProvisioningStatus} will return
     * {@link LicenseServerEndpointProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseServerEndpointProvisioningStatusAsString}.
     * </p>
     * 
     * @return The current state of the provisioning process for the RDS license server endpoint
     * @see LicenseServerEndpointProvisioningStatus
     */
    public final LicenseServerEndpointProvisioningStatus licenseServerEndpointProvisioningStatus() {
        return LicenseServerEndpointProvisioningStatus.fromValue(licenseServerEndpointProvisioningStatus);
    }

    /**
     * <p>
     * The current state of the provisioning process for the RDS license server endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseServerEndpointProvisioningStatus} will return
     * {@link LicenseServerEndpointProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseServerEndpointProvisioningStatusAsString}.
     * </p>
     * 
     * @return The current state of the provisioning process for the RDS license server endpoint
     * @see LicenseServerEndpointProvisioningStatus
     */
    public final String licenseServerEndpointProvisioningStatusAsString() {
        return licenseServerEndpointProvisioningStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseServers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseServers() {
        return licenseServers != null && !(licenseServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>LicenseServer</code> resources that represent the license servers that are accessed through
     * this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseServers} method.
     * </p>
     * 
     * @return An array of <code>LicenseServer</code> resources that represent the license servers that are accessed
     *         through this endpoint.
     */
    public final List<LicenseServer> licenseServers() {
        return licenseServers;
    }

    /**
     * <p>
     * The timestamp when License Manager created the license server endpoint.
     * </p>
     * 
     * @return The timestamp when License Manager created the license server endpoint.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerEndpointProvisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseServers() ? licenseServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseServerEndpoint)) {
            return false;
        }
        LicenseServerEndpoint other = (LicenseServerEndpoint) obj;
        return Objects.equals(identityProviderArn(), other.identityProviderArn())
                && Objects.equals(serverTypeAsString(), other.serverTypeAsString())
                && Objects.equals(serverEndpoint(), other.serverEndpoint())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(licenseServerEndpointId(), other.licenseServerEndpointId())
                && Objects.equals(licenseServerEndpointArn(), other.licenseServerEndpointArn())
                && Objects.equals(licenseServerEndpointProvisioningStatusAsString(),
                        other.licenseServerEndpointProvisioningStatusAsString())
                && hasLicenseServers() == other.hasLicenseServers() && Objects.equals(licenseServers(), other.licenseServers())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseServerEndpoint").add("IdentityProviderArn", identityProviderArn())
                .add("ServerType", serverTypeAsString()).add("ServerEndpoint", serverEndpoint())
                .add("StatusMessage", statusMessage()).add("LicenseServerEndpointId", licenseServerEndpointId())
                .add("LicenseServerEndpointArn", licenseServerEndpointArn())
                .add("LicenseServerEndpointProvisioningStatus", licenseServerEndpointProvisioningStatusAsString())
                .add("LicenseServers", hasLicenseServers() ? licenseServers() : null).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "ServerType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        case "ServerEndpoint":
            return Optional.ofNullable(clazz.cast(serverEndpoint()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "LicenseServerEndpointId":
            return Optional.ofNullable(clazz.cast(licenseServerEndpointId()));
        case "LicenseServerEndpointArn":
            return Optional.ofNullable(clazz.cast(licenseServerEndpointArn()));
        case "LicenseServerEndpointProvisioningStatus":
            return Optional.ofNullable(clazz.cast(licenseServerEndpointProvisioningStatusAsString()));
        case "LicenseServers":
            return Optional.ofNullable(clazz.cast(licenseServers()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("ServerType", SERVER_TYPE_FIELD);
        map.put("ServerEndpoint", SERVER_ENDPOINT_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("LicenseServerEndpointId", LICENSE_SERVER_ENDPOINT_ID_FIELD);
        map.put("LicenseServerEndpointArn", LICENSE_SERVER_ENDPOINT_ARN_FIELD);
        map.put("LicenseServerEndpointProvisioningStatus", LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD);
        map.put("LicenseServers", LICENSE_SERVERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseServerEndpoint, T> g) {
        return obj -> g.apply((LicenseServerEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseServerEndpoint> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity provider that's associated with the RDS license server
         * endpoint.
         * </p>
         * 
         * @param identityProviderArn
         *        The Amazon Resource Name (ARN) of the identity provider that's associated with the RDS license server
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The type of license server.
         * </p>
         * 
         * @param serverType
         *        The type of license server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of license server.
         * </p>
         * 
         * @param serverType
         *        The type of license server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        /**
         * <p>
         * The <code>ServerEndpoint</code> resource contains the network address of the RDS license server endpoint.
         * </p>
         * 
         * @param serverEndpoint
         *        The <code>ServerEndpoint</code> resource contains the network address of the RDS license server
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverEndpoint(ServerEndpoint serverEndpoint);

        /**
         * <p>
         * The <code>ServerEndpoint</code> resource contains the network address of the RDS license server endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerEndpoint.Builder} avoiding the need
         * to create one manually via {@link ServerEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #serverEndpoint(ServerEndpoint)}.
         * 
         * @param serverEndpoint
         *        a consumer that will call methods on {@link ServerEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverEndpoint(ServerEndpoint)
         */
        default Builder serverEndpoint(Consumer<ServerEndpoint.Builder> serverEndpoint) {
            return serverEndpoint(ServerEndpoint.builder().applyMutation(serverEndpoint).build());
        }

        /**
         * <p>
         * The message associated with the provisioning status, if there is one.
         * </p>
         * 
         * @param statusMessage
         *        The message associated with the provisioning status, if there is one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The ID of the license server endpoint.
         * </p>
         * 
         * @param licenseServerEndpointId
         *        The ID of the license server endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpointId(String licenseServerEndpointId);

        /**
         * <p>
         * The ARN of the <code>ServerEndpoint</code> resource for the RDS license server.
         * </p>
         * 
         * @param licenseServerEndpointArn
         *        The ARN of the <code>ServerEndpoint</code> resource for the RDS license server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpointArn(String licenseServerEndpointArn);

        /**
         * <p>
         * The current state of the provisioning process for the RDS license server endpoint
         * </p>
         * 
         * @param licenseServerEndpointProvisioningStatus
         *        The current state of the provisioning process for the RDS license server endpoint
         * @see LicenseServerEndpointProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerEndpointProvisioningStatus
         */
        Builder licenseServerEndpointProvisioningStatus(String licenseServerEndpointProvisioningStatus);

        /**
         * <p>
         * The current state of the provisioning process for the RDS license server endpoint
         * </p>
         * 
         * @param licenseServerEndpointProvisioningStatus
         *        The current state of the provisioning process for the RDS license server endpoint
         * @see LicenseServerEndpointProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerEndpointProvisioningStatus
         */
        Builder licenseServerEndpointProvisioningStatus(
                LicenseServerEndpointProvisioningStatus licenseServerEndpointProvisioningStatus);

        /**
         * <p>
         * An array of <code>LicenseServer</code> resources that represent the license servers that are accessed through
         * this endpoint.
         * </p>
         * 
         * @param licenseServers
         *        An array of <code>LicenseServer</code> resources that represent the license servers that are accessed
         *        through this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServers(Collection<LicenseServer> licenseServers);

        /**
         * <p>
         * An array of <code>LicenseServer</code> resources that represent the license servers that are accessed through
         * this endpoint.
         * </p>
         * 
         * @param licenseServers
         *        An array of <code>LicenseServer</code> resources that represent the license servers that are accessed
         *        through this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServers(LicenseServer... licenseServers);

        /**
         * <p>
         * An array of <code>LicenseServer</code> resources that represent the license servers that are accessed through
         * this endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServer.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServer.Builder#build()}
         * is called immediately and its result is passed to {@link #licenseServers(List<LicenseServer>)}.
         * 
         * @param licenseServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseServers(java.util.Collection<LicenseServer>)
         */
        Builder licenseServers(Consumer<LicenseServer.Builder>... licenseServers);

        /**
         * <p>
         * The timestamp when License Manager created the license server endpoint.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when License Manager created the license server endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String identityProviderArn;

        private String serverType;

        private ServerEndpoint serverEndpoint;

        private String statusMessage;

        private String licenseServerEndpointId;

        private String licenseServerEndpointArn;

        private String licenseServerEndpointProvisioningStatus;

        private List<LicenseServer> licenseServers = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseServerEndpoint model) {
            identityProviderArn(model.identityProviderArn);
            serverType(model.serverType);
            serverEndpoint(model.serverEndpoint);
            statusMessage(model.statusMessage);
            licenseServerEndpointId(model.licenseServerEndpointId);
            licenseServerEndpointArn(model.licenseServerEndpointArn);
            licenseServerEndpointProvisioningStatus(model.licenseServerEndpointProvisioningStatus);
            licenseServers(model.licenseServers);
            creationTime(model.creationTime);
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final ServerEndpoint.Builder getServerEndpoint() {
            return serverEndpoint != null ? serverEndpoint.toBuilder() : null;
        }

        public final void setServerEndpoint(ServerEndpoint.BuilderImpl serverEndpoint) {
            this.serverEndpoint = serverEndpoint != null ? serverEndpoint.build() : null;
        }

        @Override
        public final Builder serverEndpoint(ServerEndpoint serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getLicenseServerEndpointId() {
            return licenseServerEndpointId;
        }

        public final void setLicenseServerEndpointId(String licenseServerEndpointId) {
            this.licenseServerEndpointId = licenseServerEndpointId;
        }

        @Override
        public final Builder licenseServerEndpointId(String licenseServerEndpointId) {
            this.licenseServerEndpointId = licenseServerEndpointId;
            return this;
        }

        public final String getLicenseServerEndpointArn() {
            return licenseServerEndpointArn;
        }

        public final void setLicenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
        }

        @Override
        public final Builder licenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
            return this;
        }

        public final String getLicenseServerEndpointProvisioningStatus() {
            return licenseServerEndpointProvisioningStatus;
        }

        public final void setLicenseServerEndpointProvisioningStatus(String licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus = licenseServerEndpointProvisioningStatus;
        }

        @Override
        public final Builder licenseServerEndpointProvisioningStatus(String licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus = licenseServerEndpointProvisioningStatus;
            return this;
        }

        @Override
        public final Builder licenseServerEndpointProvisioningStatus(
                LicenseServerEndpointProvisioningStatus licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus(licenseServerEndpointProvisioningStatus == null ? null
                    : licenseServerEndpointProvisioningStatus.toString());
            return this;
        }

        public final List<LicenseServer.Builder> getLicenseServers() {
            List<LicenseServer.Builder> result = LicenseServerListCopier.copyToBuilder(this.licenseServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseServers(Collection<LicenseServer.BuilderImpl> licenseServers) {
            this.licenseServers = LicenseServerListCopier.copyFromBuilder(licenseServers);
        }

        @Override
        public final Builder licenseServers(Collection<LicenseServer> licenseServers) {
            this.licenseServers = LicenseServerListCopier.copy(licenseServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServers(LicenseServer... licenseServers) {
            licenseServers(Arrays.asList(licenseServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServers(Consumer<LicenseServer.Builder>... licenseServers) {
            licenseServers(Stream.of(licenseServers).map(c -> LicenseServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public LicenseServerEndpoint build() {
            return new LicenseServerEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
