/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseServerEndpointsResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<ListLicenseServerEndpointsResponse.Builder, ListLicenseServerEndpointsResponse> {
    private static final SdkField<List<LicenseServerEndpoint>> LICENSE_SERVER_ENDPOINTS_FIELD = SdkField
            .<List<LicenseServerEndpoint>> builder(MarshallingType.LIST)
            .memberName("LicenseServerEndpoints")
            .getter(getter(ListLicenseServerEndpointsResponse::licenseServerEndpoints))
            .setter(setter(Builder::licenseServerEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseServerEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseServerEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseServerEndpointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_SERVER_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LicenseServerEndpoint> licenseServerEndpoints;

    private final String nextToken;

    private ListLicenseServerEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseServerEndpoints = builder.licenseServerEndpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseServerEndpoints property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseServerEndpoints() {
        return licenseServerEndpoints != null && !(licenseServerEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the RDS License
     * Servers that meet the request criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseServerEndpoints} method.
     * </p>
     * 
     * @return An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the RDS
     *         License Servers that meet the request criteria.
     */
    public final List<LicenseServerEndpoint> licenseServerEndpoints() {
        return licenseServerEndpoints;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseServerEndpoints() ? licenseServerEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseServerEndpointsResponse)) {
            return false;
        }
        ListLicenseServerEndpointsResponse other = (ListLicenseServerEndpointsResponse) obj;
        return hasLicenseServerEndpoints() == other.hasLicenseServerEndpoints()
                && Objects.equals(licenseServerEndpoints(), other.licenseServerEndpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicenseServerEndpointsResponse")
                .add("LicenseServerEndpoints", hasLicenseServerEndpoints() ? licenseServerEndpoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseServerEndpoints":
            return Optional.ofNullable(clazz.cast(licenseServerEndpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicenseServerEndpoints", LICENSE_SERVER_ENDPOINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseServerEndpointsResponse, T> g) {
        return obj -> g.apply((ListLicenseServerEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseServerEndpointsResponse> {
        /**
         * <p>
         * An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the RDS
         * License Servers that meet the request criteria.
         * </p>
         * 
         * @param licenseServerEndpoints
         *        An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the
         *        RDS License Servers that meet the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpoints(Collection<LicenseServerEndpoint> licenseServerEndpoints);

        /**
         * <p>
         * An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the RDS
         * License Servers that meet the request criteria.
         * </p>
         * 
         * @param licenseServerEndpoints
         *        An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the
         *        RDS License Servers that meet the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpoints(LicenseServerEndpoint... licenseServerEndpoints);

        /**
         * <p>
         * An array of <code>LicenseServerEndpoint</code> resources that contain detailed information about the RDS
         * License Servers that meet the request criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #licenseServerEndpoints(List<LicenseServerEndpoint>)}.
         * 
         * @param licenseServerEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseServerEndpoints(java.util.Collection<LicenseServerEndpoint>)
         */
        Builder licenseServerEndpoints(Consumer<LicenseServerEndpoint.Builder>... licenseServerEndpoints);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private List<LicenseServerEndpoint> licenseServerEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseServerEndpointsResponse model) {
            super(model);
            licenseServerEndpoints(model.licenseServerEndpoints);
            nextToken(model.nextToken);
        }

        public final List<LicenseServerEndpoint.Builder> getLicenseServerEndpoints() {
            List<LicenseServerEndpoint.Builder> result = LicenseServerEndpointListCopier
                    .copyToBuilder(this.licenseServerEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseServerEndpoints(Collection<LicenseServerEndpoint.BuilderImpl> licenseServerEndpoints) {
            this.licenseServerEndpoints = LicenseServerEndpointListCopier.copyFromBuilder(licenseServerEndpoints);
        }

        @Override
        public final Builder licenseServerEndpoints(Collection<LicenseServerEndpoint> licenseServerEndpoints) {
            this.licenseServerEndpoints = LicenseServerEndpointListCopier.copy(licenseServerEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServerEndpoints(LicenseServerEndpoint... licenseServerEndpoints) {
            licenseServerEndpoints(Arrays.asList(licenseServerEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServerEndpoints(Consumer<LicenseServerEndpoint.Builder>... licenseServerEndpoints) {
            licenseServerEndpoints(Stream.of(licenseServerEndpoints)
                    .map(c -> LicenseServerEndpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseServerEndpointsResponse build() {
            return new ListLicenseServerEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
