/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProductSubscriptionRequest extends LicenseManagerUserSubscriptionsRequest implements
        ToCopyableBuilder<StartProductSubscriptionRequest.Builder, StartProductSubscriptionRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(StartProductSubscriptionRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(StartProductSubscriptionRequest::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(StartProductSubscriptionRequest::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(StartProductSubscriptionRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartProductSubscriptionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            IDENTITY_PROVIDER_FIELD, PRODUCT_FIELD, DOMAIN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String username;

    private final IdentityProvider identityProvider;

    private final String product;

    private final String domain;

    private final Map<String, String> tags;

    private StartProductSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.identityProvider = builder.identityProvider;
        this.product = builder.product;
        this.domain = builder.domain;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The user name from the identity provider of the user.
     * </p>
     * 
     * @return The user name from the identity provider of the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * An object that specifies details for the identity provider.
     * </p>
     * 
     * @return An object that specifies details for the identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The name of the user-based subscription product.
     * </p>
     * <p>
     * Valid values: <code>VISUAL_STUDIO_ENTERPRISE</code> | <code>VISUAL_STUDIO_PROFESSIONAL</code> |
     * <code>OFFICE_PROFESSIONAL_PLUS</code> | <code>REMOTE_DESKTOP_SERVICES</code>
     * </p>
     * 
     * @return The name of the user-based subscription product.</p>
     *         <p>
     *         Valid values: <code>VISUAL_STUDIO_ENTERPRISE</code> | <code>VISUAL_STUDIO_PROFESSIONAL</code> |
     *         <code>OFFICE_PROFESSIONAL_PLUS</code> | <code>REMOTE_DESKTOP_SERVICES</code>
     */
    public final String product() {
        return product;
    }

    /**
     * <p>
     * The domain name of the Active Directory that contains the user for whom to start the product subscription.
     * </p>
     * 
     * @return The domain name of the Active Directory that contains the user for whom to start the product
     *         subscription.
     */
    public final String domain() {
        return domain;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that apply to the product subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that apply to the product subscription.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProductSubscriptionRequest)) {
            return false;
        }
        StartProductSubscriptionRequest other = (StartProductSubscriptionRequest) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(identityProvider(), other.identityProvider())
                && Objects.equals(product(), other.product()) && Objects.equals(domain(), other.domain())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProductSubscriptionRequest").add("Username", username())
                .add("IdentityProvider", identityProvider()).add("Product", product()).add("Domain", domain())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("Product", PRODUCT_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProductSubscriptionRequest, T> g) {
        return obj -> g.apply((StartProductSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerUserSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartProductSubscriptionRequest> {
        /**
         * <p>
         * The user name from the identity provider of the user.
         * </p>
         * 
         * @param username
         *        The user name from the identity provider of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * 
         * @param identityProvider
         *        An object that specifies details for the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The name of the user-based subscription product.
         * </p>
         * <p>
         * Valid values: <code>VISUAL_STUDIO_ENTERPRISE</code> | <code>VISUAL_STUDIO_PROFESSIONAL</code> |
         * <code>OFFICE_PROFESSIONAL_PLUS</code> | <code>REMOTE_DESKTOP_SERVICES</code>
         * </p>
         * 
         * @param product
         *        The name of the user-based subscription product.</p>
         *        <p>
         *        Valid values: <code>VISUAL_STUDIO_ENTERPRISE</code> | <code>VISUAL_STUDIO_PROFESSIONAL</code> |
         *        <code>OFFICE_PROFESSIONAL_PLUS</code> | <code>REMOTE_DESKTOP_SERVICES</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * The domain name of the Active Directory that contains the user for whom to start the product subscription.
         * </p>
         * 
         * @param domain
         *        The domain name of the Active Directory that contains the user for whom to start the product
         *        subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The tags that apply to the product subscription.
         * </p>
         * 
         * @param tags
         *        The tags that apply to the product subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsRequest.BuilderImpl implements Builder {
        private String username;

        private IdentityProvider identityProvider;

        private String product;

        private String domain;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartProductSubscriptionRequest model) {
            super(model);
            username(model.username);
            identityProvider(model.identityProvider);
            product(model.product);
            domain(model.domain);
            tags(model.tags);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProductSubscriptionRequest build() {
            return new StartProductSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
