/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryResponseUnmarshaller;

/**
 * Internal implementation of {@link LightsailClient}.
 *
 * @see LightsailClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLightsailClient implements LightsailClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final AwsSyncClientParams clientParams;

    protected DefaultLightsailClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams)
                .withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     * 
     * @param allocateStaticIpRequest
     * @return Result of the AllocateStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AllocateStaticIpResponse allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<AllocateStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AllocateStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AllocateStaticIpRequest, AllocateStaticIpResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(allocateStaticIpRequest).withMarshaller(new AllocateStaticIpRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     * 
     * @param attachStaticIpRequest
     * @return Result of the AttachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachStaticIpResponse attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<AttachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AttachStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AttachStaticIpRequest, AttachStaticIpResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(attachStaticIpRequest).withMarshaller(new AttachStaticIpRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     * 
     * @param closeInstancePublicPortsRequest
     * @return Result of the CloseInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CloseInstancePublicPortsResponse closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CloseInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CloseInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(closeInstancePublicPortsRequest)
                        .withMarshaller(new CloseInstancePublicPortsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * 
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDomainRequest).withMarshaller(new CreateDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX
     * record.
     * </p>
     * 
     * @param createDomainEntryRequest
     * @return Result of the CreateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDomainEntryResponse createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDomainEntryRequest, CreateDomainEntryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDomainEntryRequest).withMarshaller(new CreateDomainEntryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * 
     * @param createInstanceSnapshotRequest
     * @return Result of the CreateInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInstanceSnapshotResponse createInstanceSnapshot(CreateInstanceSnapshotRequest createInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createInstanceSnapshotRequest)
                .withMarshaller(new CreateInstanceSnapshotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * 
     * @param createInstancesRequest
     * @return Result of the CreateInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateInstancesResponse createInstances(CreateInstancesRequest createInstancesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateInstancesRequest, CreateInstancesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createInstancesRequest).withMarshaller(new CreateInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical
     * configuration.
     * </p>
     * 
     * @param createInstancesFromSnapshotRequest
     * @return Result of the CreateInstancesFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInstancesFromSnapshotResponse createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateInstancesFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstancesFromSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createInstancesFromSnapshotRequest)
                        .withMarshaller(new CreateInstancesFromSnapshotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates sn SSH key pair.
     * </p>
     * 
     * @param createKeyPairRequest
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createKeyPairRequest).withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * 
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDomainRequest).withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * 
     * @param deleteDomainEntryRequest
     * @return Result of the DeleteDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDomainEntryResponse deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DeleteDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDomainEntryRequest, DeleteDomainEntryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDomainEntryRequest).withMarshaller(new DeleteDomainEntryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param deleteInstanceRequest
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteInstanceRequest).withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * 
     * @param deleteInstanceSnapshotRequest
     * @return Result of the DeleteInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInstanceSnapshotResponse deleteInstanceSnapshot(DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DeleteInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteInstanceSnapshotRequest)
                .withMarshaller(new DeleteInstanceSnapshotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * 
     * @param deleteKeyPairRequest
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteKeyPairRequest).withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     * 
     * @param detachStaticIpRequest
     * @return Result of the DetachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DetachStaticIpResponse detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DetachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DetachStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DetachStaticIpRequest, DetachStaticIpResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(detachStaticIpRequest).withMarshaller(new DetachStaticIpRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     * 
     * @param downloadDefaultKeyPairRequest
     * @return Result of the DownloadDefaultKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DownloadDefaultKeyPairResponse downloadDefaultKeyPair(DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<DownloadDefaultKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DownloadDefaultKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(downloadDefaultKeyPairRequest)
                .withMarshaller(new DownloadDefaultKeyPairRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     * 
     * @param getActiveNamesRequest
     * @return Result of the GetActiveNames operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetActiveNamesResponse getActiveNames(GetActiveNamesRequest getActiveNamesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetActiveNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetActiveNamesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetActiveNamesRequest, GetActiveNamesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getActiveNamesRequest).withMarshaller(new GetActiveNamesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     * 
     * @param getBlueprintsRequest
     * @return Result of the GetBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBlueprintsResponse getBlueprints(GetBlueprintsRequest getBlueprintsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetBlueprintsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBlueprintsRequest, GetBlueprintsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBlueprintsRequest).withMarshaller(new GetBlueprintsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     * 
     * @param getBundlesRequest
     * @return Result of the GetBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBundlesResponse getBundles(GetBundlesRequest getBundlesRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetBundlesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBundlesRequest, GetBundlesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getBundlesRequest)
                .withMarshaller(new GetBundlesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     * 
     * @param getDomainRequest
     * @return Result of the GetDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDomainRequest, GetDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getDomainRequest)
                .withMarshaller(new GetDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     * 
     * @param getDomainsRequest
     * @return Result of the GetDomains operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDomainsResponse getDomains(GetDomainsRequest getDomainsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDomainsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDomainsRequest, GetDomainsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getDomainsRequest)
                .withMarshaller(new GetDomainsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     * 
     * @param getInstanceRequest
     * @return Result of the GetInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceRequest, GetInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstanceRequest).withMarshaller(new GetInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param getInstanceAccessDetailsRequest
     * @return Result of the GetInstanceAccessDetails operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInstanceAccessDetailsResponse getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceAccessDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceAccessDetailsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getInstanceAccessDetailsRequest)
                        .withMarshaller(new GetInstanceAccessDetailsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * 
     * @param getInstanceMetricDataRequest
     * @return Result of the GetInstanceMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInstanceMetricDataResponse getInstanceMetricData(GetInstanceMetricDataRequest getInstanceMetricDataRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceMetricDataResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstanceMetricDataRequest)
                .withMarshaller(new GetInstanceMetricDataRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param getInstancePortStatesRequest
     * @return Result of the GetInstancePortStates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInstancePortStatesResponse getInstancePortStates(GetInstancePortStatesRequest getInstancePortStatesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstancePortStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstancePortStatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstancePortStatesRequest, GetInstancePortStatesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstancePortStatesRequest)
                .withMarshaller(new GetInstancePortStatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     * 
     * @param getInstanceSnapshotRequest
     * @return Result of the GetInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetInstanceSnapshotResponse getInstanceSnapshot(GetInstanceSnapshotRequest getInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstanceSnapshotRequest).withMarshaller(new GetInstanceSnapshotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     * 
     * @param getInstanceSnapshotsRequest
     * @return Result of the GetInstanceSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetInstanceSnapshotsResponse getInstanceSnapshots(GetInstanceSnapshotsRequest getInstanceSnapshotsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceSnapshotsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstanceSnapshotsRequest)
                .withMarshaller(new GetInstanceSnapshotsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     * 
     * @param getInstanceStateRequest
     * @return Result of the GetInstanceState operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInstanceStateResponse getInstanceState(GetInstanceStateRequest getInstanceStateRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstanceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceStateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceStateRequest, GetInstanceStateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstanceStateRequest).withMarshaller(new GetInstanceStateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * 
     * @param getInstancesRequest
     * @return Result of the GetInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInstancesResponse getInstances(GetInstancesRequest getInstancesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstancesRequest, GetInstancesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInstancesRequest).withMarshaller(new GetInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     * 
     * @param getKeyPairRequest
     * @return Result of the GetKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetKeyPairResponse getKeyPair(GetKeyPairRequest getKeyPairRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetKeyPairRequest, GetKeyPairResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getKeyPairRequest)
                .withMarshaller(new GetKeyPairRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     * 
     * @param getKeyPairsRequest
     * @return Result of the GetKeyPairs operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetKeyPairsResponse getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetKeyPairsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetKeyPairsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetKeyPairsRequest, GetKeyPairsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getKeyPairsRequest).withMarshaller(new GetKeyPairsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     * 
     * @param getOperationRequest
     * @return Result of the GetOperation operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOperationRequest, GetOperationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getOperationRequest).withMarshaller(new GetOperationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     * 
     * @param getOperationsRequest
     * @return Result of the GetOperations operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOperationsResponse getOperations(GetOperationsRequest getOperationsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetOperationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOperationsRequest, GetOperationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getOperationsRequest).withMarshaller(new GetOperationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     * 
     * @param getOperationsForResourceRequest
     * @return Result of the GetOperationsForResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOperationsForResourceResponse getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetOperationsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationsForResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetOperationsForResourceRequest, GetOperationsForResourceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getOperationsForResourceRequest)
                        .withMarshaller(new GetOperationsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     * 
     * @param getRegionsRequest
     * @return Result of the GetRegions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRegionsResponse getRegions(GetRegionsRequest getRegionsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetRegionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetRegionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRegionsRequest, GetRegionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRegionsRequest)
                .withMarshaller(new GetRegionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     * 
     * @param getStaticIpRequest
     * @return Result of the GetStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStaticIpResponse getStaticIp(GetStaticIpRequest getStaticIpRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetStaticIpRequest, GetStaticIpResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getStaticIpRequest).withMarshaller(new GetStaticIpRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     * 
     * @param getStaticIpsRequest
     * @return Result of the GetStaticIps operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStaticIpsResponse getStaticIps(GetStaticIpsRequest getStaticIpsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<GetStaticIpsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetStaticIpsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetStaticIpsRequest, GetStaticIpsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getStaticIpsRequest).withMarshaller(new GetStaticIpsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     * 
     * @param importKeyPairRequest
     * @return Result of the ImportKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ImportKeyPairResponse importKeyPair(ImportKeyPairRequest importKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<ImportKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ImportKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(importKeyPairRequest).withMarshaller(new ImportKeyPairRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     * 
     * @param isVpcPeeredRequest
     * @return Result of the IsVpcPeered operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public IsVpcPeeredResponse isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<IsVpcPeeredResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new IsVpcPeeredResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<IsVpcPeeredRequest, IsVpcPeeredResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(isVpcPeeredRequest).withMarshaller(new IsVpcPeeredRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     * 
     * @param openInstancePublicPortsRequest
     * @return Result of the OpenInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public OpenInstancePublicPortsResponse openInstancePublicPorts(OpenInstancePublicPortsRequest openInstancePublicPortsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<OpenInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new OpenInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(openInstancePublicPortsRequest)
                .withMarshaller(new OpenInstancePublicPortsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     * 
     * @param peerVpcRequest
     * @return Result of the PeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PeerVpcResponse peerVpc(PeerVpcRequest peerVpcRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<PeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PeerVpcResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PeerVpcRequest, PeerVpcResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(peerVpcRequest)
                .withMarshaller(new PeerVpcRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     * 
     * @param putInstancePublicPortsRequest
     * @return Result of the PutInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutInstancePublicPortsResponse putInstancePublicPorts(PutInstancePublicPortsRequest putInstancePublicPortsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<PutInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PutInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putInstancePublicPortsRequest)
                .withMarshaller(new PutInstancePublicPortsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new
     * public IP address. To use the same IP address after restarting, create a static IP address and attach it to the
     * instance.
     * </p>
     * 
     * @param rebootInstanceRequest
     * @return Result of the RebootInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootInstanceResponse rebootInstance(RebootInstanceRequest rebootInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RebootInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(rebootInstanceRequest).withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     * 
     * @param releaseStaticIpRequest
     * @return Result of the ReleaseStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ReleaseStaticIpResponse releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<ReleaseStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ReleaseStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ReleaseStaticIpRequest, ReleaseStaticIpResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(releaseStaticIpRequest).withMarshaller(new ReleaseStaticIpRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance
     * operation.
     * </p>
     * 
     * @param startInstanceRequest
     * @return Result of the StartInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartInstanceResponse startInstance(StartInstanceRequest startInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StartInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(startInstanceRequest).withMarshaller(new StartInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * 
     * @param stopInstanceRequest
     * @return Result of the StopInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopInstanceResponse stopInstance(StopInstanceRequest stopInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StopInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(stopInstanceRequest).withMarshaller(new StopInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     * 
     * @param unpeerVpcRequest
     * @return Result of the UnpeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UnpeerVpcResponse unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<UnpeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UnpeerVpcResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UnpeerVpcRequest, UnpeerVpcResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(unpeerVpcRequest)
                .withMarshaller(new UnpeerVpcRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * 
     * @param updateDomainEntryRequest
     * @return Result of the UpdateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws LightsailException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample LightsailClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDomainEntryResponse updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, SdkBaseException, SdkClientException, LightsailException {

        HttpResponseHandler<UpdateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDomainEntryRequest, UpdateDomainEntryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDomainEntryRequest).withMarshaller(new UpdateDomainEntryRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(
                new JsonClientMetadata()
                        .withProtocolVersion("1.1")
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.lightsail.model.LightsailException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(
                                        ServiceException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("OperationFailureException").withModeledClass(
                                        OperationFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(
                                        AccessDeniedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(
                                        InvalidInputException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccountSetupInProgressException").withModeledClass(
                                        AccountSetupInProgressException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("UnauthenticatedException").withModeledClass(
                                        UnauthenticatedException.class)));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }
}
