/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.DomainEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a domain recordset entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainEntry implements StructuredPojo, ToCopyableBuilder<DomainEntry.Builder, DomainEntry> {
    private final String id;

    private final String name;

    private final String target;

    private final String type;

    private final Map<String, String> options;

    private DomainEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.target = builder.target;
        this.type = builder.type;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the domain recordset entry.
     * </p>
     * 
     * @return The ID of the domain recordset entry.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The target AWS name server (e.g., <code>ns-111.awsdns-22.com.</code>).
     * </p>
     * 
     * @return The target AWS name server (e.g., <code>ns-111.awsdns-22.com.</code>).
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The type of domain entry (e.g., <code>SOA</code> or <code>NS</code>).
     * </p>
     * 
     * @return The type of domain entry (e.g., <code>SOA</code> or <code>NS</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The options for the domain entry.
     * </p>
     * 
     * @return The options for the domain entry.
     */
    public Map<String, String> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((target() == null) ? 0 : target().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((options() == null) ? 0 : options().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntry)) {
            return false;
        }
        DomainEntry other = (DomainEntry) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.target() == null ^ this.target() == null) {
            return false;
        }
        if (other.target() != null && !other.target().equals(this.target())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (target() != null) {
            sb.append("Target: ").append(target()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (options() != null) {
            sb.append("Options: ").append(options()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainEntry> {
        /**
         * <p>
         * The ID of the domain recordset entry.
         * </p>
         * 
         * @param id
         *        The ID of the domain recordset entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The target AWS name server (e.g., <code>ns-111.awsdns-22.com.</code>).
         * </p>
         * 
         * @param target
         *        The target AWS name server (e.g., <code>ns-111.awsdns-22.com.</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The type of domain entry (e.g., <code>SOA</code> or <code>NS</code>).
         * </p>
         * 
         * @param type
         *        The type of domain entry (e.g., <code>SOA</code> or <code>NS</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The options for the domain entry.
         * </p>
         * 
         * @param options
         *        The options for the domain entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Map<String, String> options);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String target;

        private String type;

        private Map<String, String> options;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntry model) {
            setId(model.id);
            setName(model.name);
            setTarget(model.target);
            setType(model.type);
            setOptions(model.options);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getOptions() {
            return options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
        }

        @Override
        public DomainEntry build() {
            return new DomainEntry(this);
        }
    }
}
