/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceMetricDataRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetInstanceMetricDataRequest.Builder, GetInstanceMetricDataRequest> {
    private final String instanceName;

    private final String metricName;

    private final Integer period;

    private final Date startTime;

    private final Date endTime;

    private final String unit;

    private final List<String> statistics;

    private GetInstanceMetricDataRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The name of the instance for which you want to get metrics data.
     * </p>
     * 
     * @return The name of the instance for which you want to get metrics data.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The metric name to get data about.
     * </p>
     * 
     * @return The metric name to get data about.
     * @see InstanceMetricName
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The time period for which you are requesting data.
     * </p>
     * 
     * @return The time period for which you are requesting data.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The start time of the time period.
     * </p>
     * 
     * @return The start time of the time period.
     */
    public Date startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the time period.
     * </p>
     * 
     * @return The end time of the time period.
     */
    public Date endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unit. The list of valid values is below.
     * </p>
     * 
     * @return The unit. The list of valid values is below.
     * @see MetricUnit
     */
    public String unit() {
        return unit;
    }

    /**
     * <p>
     * The instance statistics.
     * </p>
     * 
     * @return The instance statistics.
     * @see MetricStatistic
     */
    public List<String> statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((period() == null) ? 0 : period().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        hashCode = 31 * hashCode + ((statistics() == null) ? 0 : statistics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataRequest)) {
            return false;
        }
        GetInstanceMetricDataRequest other = (GetInstanceMetricDataRequest) obj;
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.statistics() == null ^ this.statistics() == null) {
            return false;
        }
        if (other.statistics() != null && !other.statistics().equals(this.statistics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        if (statistics() != null) {
            sb.append("Statistics: ").append(statistics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceMetricDataRequest> {
        /**
         * <p>
         * The name of the instance for which you want to get metrics data.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance for which you want to get metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The metric name to get data about.
         * </p>
         * 
         * @param metricName
         *        The metric name to get data about.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric name to get data about.
         * </p>
         * 
         * @param metricName
         *        The metric name to get data about.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(InstanceMetricName metricName);

        /**
         * <p>
         * The time period for which you are requesting data.
         * </p>
         * 
         * @param period
         *        The time period for which you are requesting data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The start time of the time period.
         * </p>
         * 
         * @param startTime
         *        The start time of the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Date startTime);

        /**
         * <p>
         * The end time of the time period.
         * </p>
         * 
         * @param endTime
         *        The end time of the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Date endTime);

        /**
         * <p>
         * The unit. The list of valid values is below.
         * </p>
         * 
         * @param unit
         *        The unit. The list of valid values is below.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit. The list of valid values is below.
         * </p>
         * 
         * @param unit
         *        The unit. The list of valid values is below.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);

        /**
         * <p>
         * The instance statistics.
         * </p>
         * 
         * @param statistics
         *        The instance statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder statistics(Collection<String> statistics);

        /**
         * <p>
         * The instance statistics.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStatistics(java.util.Collection)} or {@link #withStatistics(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param statistics
         *        The instance statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder statistics(String... statistics);

        /**
         * <p>
         * The instance statistics.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStatistics(java.util.Collection)} or {@link #withStatistics(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param statistics
         *        The instance statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder statistics(MetricStatistic... statistics);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceName;

        private String metricName;

        private Integer period;

        private Date startTime;

        private Date endTime;

        private String unit;

        private List<String> statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataRequest model) {
            setInstanceName(model.instanceName);
            setMetricName(model.metricName);
            setPeriod(model.period);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setUnit(model.unit);
            setStatistics(model.statistics);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final void setMetricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Date getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(MetricUnit unit) {
            this.unit(unit.toString());
        }

        public final Collection<String> getStatistics() {
            return statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String... statistics) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<>(statistics.length);
            }
            for (String e : statistics) {
                this.statistics.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic... statistics) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<String>(statistics.length);
            }
            for (MetricStatistic ele : statistics) {
                this.statistics.add(ele.toString());
            }
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @SafeVarargs
        public final void setStatistics(String... statistics) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<>(statistics.length);
            }
            for (String e : statistics) {
                this.statistics.add(e);
            }
        }

        @SafeVarargs
        public final void setStatistics(MetricStatistic... statistics) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<String>(statistics.length);
            }
            for (MetricStatistic ele : statistics) {
                this.statistics.add(ele.toString());
            }
        }

        @Override
        public GetInstanceMetricDataRequest build() {
            return new GetInstanceMetricDataRequest(this);
        }
    }
}
