/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceSnapshotsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceSnapshotsResponse.Builder, GetInstanceSnapshotsResponse> {
    private final List<InstanceSnapshot> instanceSnapshots;

    private final String nextPageToken;

    private GetInstanceSnapshotsResponse(BuilderImpl builder) {
        this.instanceSnapshots = builder.instanceSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance snapshots request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance snapshots
     *         request.
     */
    public List<InstanceSnapshot> instanceSnapshots() {
        return instanceSnapshots;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get instance snapshots request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get instance snapshots request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceSnapshots() == null) ? 0 : instanceSnapshots().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotsResponse)) {
            return false;
        }
        GetInstanceSnapshotsResponse other = (GetInstanceSnapshotsResponse) obj;
        if (other.instanceSnapshots() == null ^ this.instanceSnapshots() == null) {
            return false;
        }
        if (other.instanceSnapshots() != null && !other.instanceSnapshots().equals(this.instanceSnapshots())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceSnapshots() != null) {
            sb.append("InstanceSnapshots: ").append(instanceSnapshots()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshots request.
         * </p>
         * 
         * @param instanceSnapshots
         *        An array of key-value pairs containing information about the results of your get instance snapshots
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshots request.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceSnapshots(java.util.Collection)} or {@link #withInstanceSnapshots(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param instanceSnapshots
         *        An array of key-value pairs containing information about the results of your get instance snapshots
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshots(InstanceSnapshot... instanceSnapshots);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get instance snapshots request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get instance snapshots request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceSnapshot> instanceSnapshots;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotsResponse model) {
            setInstanceSnapshots(model.instanceSnapshots);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<InstanceSnapshot> getInstanceSnapshots() {
            return instanceSnapshots;
        }

        @Override
        public final Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(InstanceSnapshot... instanceSnapshots) {
            if (this.instanceSnapshots == null) {
                this.instanceSnapshots = new ArrayList<>(instanceSnapshots.length);
            }
            for (InstanceSnapshot e : instanceSnapshots) {
                this.instanceSnapshots.add(e);
            }
            return this;
        }

        public final void setInstanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
        }

        @SafeVarargs
        public final void setInstanceSnapshots(InstanceSnapshot... instanceSnapshots) {
            if (this.instanceSnapshots == null) {
                this.instanceSnapshots = new ArrayList<>(instanceSnapshots.length);
            }
            for (InstanceSnapshot e : instanceSnapshots) {
                this.instanceSnapshots.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetInstanceSnapshotsResponse build() {
            return new GetInstanceSnapshotsResponse(this);
        }
    }
}
