/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceStateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceStateResponse.Builder, GetInstanceStateResponse> {
    private final InstanceState state;

    private GetInstanceStateResponse(BuilderImpl builder) {
        this.state = builder.state;
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * 
     * @return The state of the instance.
     */
    public InstanceState state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceStateResponse)) {
            return false;
        }
        GetInstanceStateResponse other = (GetInstanceStateResponse) obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceStateResponse> {
        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param state
         *        The state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);
    }

    private static final class BuilderImpl implements Builder {
        private InstanceState state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceStateResponse model) {
            setState(model.state);
        }

        public final InstanceState getState() {
            return state;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState state) {
            this.state = state;
        }

        @Override
        public GetInstanceStateResponse build() {
            return new GetInstanceStateResponse(this);
        }
    }
}
