/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOperationsResponse.Builder, GetOperationsResponse> {
    private final List<Operation> operations;

    private final String nextPageToken;

    private GetOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get operations request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get operations request.
     */
    public List<Operation> operations() {
        return operations;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get operations request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get operations request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operations() == null) ? 0 : operations().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsResponse)) {
            return false;
        }
        GetOperationsResponse other = (GetOperationsResponse) obj;
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOperationsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations request.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOperations(java.util.Collection)} or {@link #withOperations(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get operations request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Operation> operations;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsResponse model) {
            setOperations(model.operations);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<Operation> getOperations() {
            return operations;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            if (this.operations == null) {
                this.operations = new ArrayList<>(operations.length);
            }
            for (Operation e : operations) {
                this.operations.add(e);
            }
            return this;
        }

        public final void setOperations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
        }

        @SafeVarargs
        public final void setOperations(Operation... operations) {
            if (this.operations == null) {
                this.operations = new ArrayList<>(operations.length);
            }
            for (Operation e : operations) {
                this.operations.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetOperationsResponse build() {
            return new GetOperationsResponse(this);
        }
    }
}
