/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ImportKeyPairResponse.Builder, ImportKeyPairResponse> {
    private final Operation operation;

    private ImportKeyPairResponse(BuilderImpl builder) {
        this.operation = builder.operation;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the request operation.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the request operation.
     */
    public Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operation() == null) ? 0 : operation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairResponse)) {
            return false;
        }
        ImportKeyPairResponse other = (ImportKeyPairResponse) obj;
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operation() != null) {
            sb.append("Operation: ").append(operation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportKeyPairResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the request operation.
         * </p>
         * 
         * @param operation
         *        An array of key-value pairs containing information about the request operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);
    }

    private static final class BuilderImpl implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairResponse model) {
            setOperation(model.operation);
        }

        public final Operation getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation operation) {
            this.operation = operation;
        }

        @Override
        public ImportKeyPairResponse build() {
            return new ImportKeyPairResponse(this);
        }
    }
}
