/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lightsail.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance (a virtual private server).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements StructuredPojo, ToCopyableBuilder<Instance.Builder, Instance> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Date createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String blueprintId;

    private final String blueprintName;

    private final String bundleId;

    private final Boolean isStaticIp;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private final String ipv6Address;

    private final InstanceHardware hardware;

    private final InstanceNetworking networking;

    private final InstanceState state;

    private final String username;

    private final String sshKeyName;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Address = builder.ipv6Address;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
    }

    /**
     * <p>
     * The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
     * </p>
     * 
     * @return The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance (e.g.,
     * <code>arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance (e.g.,
     *         <code>arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
     * </p>
     * 
     * @return The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
     */
    public Date createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region name and availability zone where the instance is located.
     * </p>
     * 
     * @return The region name and availability zone where the instance is located.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The type of resource (usually <code>Instance</code>).
     * </p>
     * 
     * @return The type of resource (usually <code>Instance</code>).
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
     * </p>
     * 
     * @return The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
     */
    public String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     */
    public String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The bundle for the instance (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle for the instance (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     * </p>
     * 
     * @return A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public Boolean isStaticIp() {
        return isStaticIp;
    }

    /**
     * <p>
     * The private IP address of the instance.
     * </p>
     * 
     * @return The private IP address of the instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IP address of the instance.
     * </p>
     * 
     * @return The public IP address of the instance.
     */
    public String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The IPv6 address of the instance.
     * </p>
     * 
     * @return The IPv6 address of the instance.
     */
    public String ipv6Address() {
        return ipv6Address;
    }

    /**
     * <p>
     * The size of the vCPU and the amount of RAM for the instance.
     * </p>
     * 
     * @return The size of the vCPU and the amount of RAM for the instance.
     */
    public InstanceHardware hardware() {
        return hardware;
    }

    /**
     * <p>
     * Information about the public ports and monthly data transfer rates for the instance.
     * </p>
     * 
     * @return Information about the public ports and monthly data transfer rates for the instance.
     */
    public InstanceNetworking networking() {
        return networking;
    }

    /**
     * <p>
     * The status code and the state (e.g., <code>running</code>) for the instance.
     * </p>
     * 
     * @return The status code and the state (e.g., <code>running</code>) for the instance.
     */
    public InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The user name for connecting to the instance (e.g., <code>ec2-user</code>).
     * </p>
     * 
     * @return The user name for connecting to the instance (e.g., <code>ec2-user</code>).
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>).
     * </p>
     * 
     * @return The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>
     *         ).
     */
    public String sshKeyName() {
        return sshKeyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((supportCode() == null) ? 0 : supportCode().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((blueprintId() == null) ? 0 : blueprintId().hashCode());
        hashCode = 31 * hashCode + ((blueprintName() == null) ? 0 : blueprintName().hashCode());
        hashCode = 31 * hashCode + ((bundleId() == null) ? 0 : bundleId().hashCode());
        hashCode = 31 * hashCode + ((isStaticIp() == null) ? 0 : isStaticIp().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((publicIpAddress() == null) ? 0 : publicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((ipv6Address() == null) ? 0 : ipv6Address().hashCode());
        hashCode = 31 * hashCode + ((hardware() == null) ? 0 : hardware().hashCode());
        hashCode = 31 * hashCode + ((networking() == null) ? 0 : networking().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((username() == null) ? 0 : username().hashCode());
        hashCode = 31 * hashCode + ((sshKeyName() == null) ? 0 : sshKeyName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.blueprintId() == null ^ this.blueprintId() == null) {
            return false;
        }
        if (other.blueprintId() != null && !other.blueprintId().equals(this.blueprintId())) {
            return false;
        }
        if (other.blueprintName() == null ^ this.blueprintName() == null) {
            return false;
        }
        if (other.blueprintName() != null && !other.blueprintName().equals(this.blueprintName())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.isStaticIp() == null ^ this.isStaticIp() == null) {
            return false;
        }
        if (other.isStaticIp() != null && !other.isStaticIp().equals(this.isStaticIp())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.publicIpAddress() == null ^ this.publicIpAddress() == null) {
            return false;
        }
        if (other.publicIpAddress() != null && !other.publicIpAddress().equals(this.publicIpAddress())) {
            return false;
        }
        if (other.ipv6Address() == null ^ this.ipv6Address() == null) {
            return false;
        }
        if (other.ipv6Address() != null && !other.ipv6Address().equals(this.ipv6Address())) {
            return false;
        }
        if (other.hardware() == null ^ this.hardware() == null) {
            return false;
        }
        if (other.hardware() != null && !other.hardware().equals(this.hardware())) {
            return false;
        }
        if (other.networking() == null ^ this.networking() == null) {
            return false;
        }
        if (other.networking() != null && !other.networking().equals(this.networking())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (blueprintId() != null) {
            sb.append("BlueprintId: ").append(blueprintId()).append(",");
        }
        if (blueprintName() != null) {
            sb.append("BlueprintName: ").append(blueprintName()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (isStaticIp() != null) {
            sb.append("IsStaticIp: ").append(isStaticIp()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(publicIpAddress()).append(",");
        }
        if (ipv6Address() != null) {
            sb.append("Ipv6Address: ").append(ipv6Address()).append(",");
        }
        if (hardware() != null) {
            sb.append("Hardware: ").append(hardware()).append(",");
        }
        if (networking() != null) {
            sb.append("Networking: ").append(networking()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (username() != null) {
            sb.append("Username: ").append(username()).append(",");
        }
        if (sshKeyName() != null) {
            sb.append("SshKeyName: ").append(sshKeyName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
         * </p>
         * 
         * @param name
         *        The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance (e.g.,
         * <code>arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the instance (e.g.,
         *        <code>arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Date createdAt);

        /**
         * <p>
         * The region name and availability zone where the instance is located.
         * </p>
         * 
         * @param location
         *        The region name and availability zone where the instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
         * </p>
         * 
         * @param blueprintId
         *        The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * </p>
         * 
         * @param blueprintName
         *        The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The bundle for the instance (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle for the instance (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * A Boolean value indicating whether this instance has a static IP assigned to it.
         * </p>
         * 
         * @param isStaticIp
         *        A Boolean value indicating whether this instance has a static IP assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isStaticIp(Boolean isStaticIp);

        /**
         * <p>
         * The private IP address of the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IP address of the instance.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The IPv6 address of the instance.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);

        /**
         * <p>
         * The size of the vCPU and the amount of RAM for the instance.
         * </p>
         * 
         * @param hardware
         *        The size of the vCPU and the amount of RAM for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardware(InstanceHardware hardware);

        /**
         * <p>
         * Information about the public ports and monthly data transfer rates for the instance.
         * </p>
         * 
         * @param networking
         *        Information about the public ports and monthly data transfer rates for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networking(InstanceNetworking networking);

        /**
         * <p>
         * The status code and the state (e.g., <code>running</code>) for the instance.
         * </p>
         * 
         * @param state
         *        The status code and the state (e.g., <code>running</code>) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The user name for connecting to the instance (e.g., <code>ec2-user</code>).
         * </p>
         * 
         * @param username
         *        The user name for connecting to the instance (e.g., <code>ec2-user</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>).
         * </p>
         * 
         * @param sshKeyName
         *        The name of the SSH key being used to connect to the instance (e.g.,
         *        <code>LightsailDefaultKeyPair</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Date createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String blueprintId;

        private String blueprintName;

        private String bundleId;

        private Boolean isStaticIp;

        private String privateIpAddress;

        private String publicIpAddress;

        private String ipv6Address;

        private InstanceHardware hardware;

        private InstanceNetworking networking;

        private InstanceState state;

        private String username;

        private String sshKeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            setName(model.name);
            setArn(model.arn);
            setSupportCode(model.supportCode);
            setCreatedAt(model.createdAt);
            setLocation(model.location);
            setResourceType(model.resourceType);
            setBlueprintId(model.blueprintId);
            setBlueprintName(model.blueprintName);
            setBundleId(model.bundleId);
            setIsStaticIp(model.isStaticIp);
            setPrivateIpAddress(model.privateIpAddress);
            setPublicIpAddress(model.publicIpAddress);
            setIpv6Address(model.ipv6Address);
            setHardware(model.hardware);
            setNetworking(model.networking);
            setState(model.state);
            setUsername(model.username);
            setSshKeyName(model.sshKeyName);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Date getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
        }

        public final ResourceLocation getLocation() {
            return location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Boolean getIsStaticIp() {
            return isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public final InstanceHardware getHardware() {
            return hardware;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final void setHardware(InstanceHardware hardware) {
            this.hardware = hardware;
        }

        public final InstanceNetworking getNetworking() {
            return networking;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final void setNetworking(InstanceNetworking networking) {
            this.networking = networking;
        }

        public final InstanceState getState() {
            return state;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState state) {
            this.state = state;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
