/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceNetworkingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes monthly data transfer rates and port information for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworking implements StructuredPojo, ToCopyableBuilder<InstanceNetworking.Builder, InstanceNetworking> {
    private final MonthlyTransfer monthlyTransfer;

    private final List<InstancePortInfo> ports;

    private InstanceNetworking(BuilderImpl builder) {
        this.monthlyTransfer = builder.monthlyTransfer;
        this.ports = builder.ports;
    }

    /**
     * <p>
     * The amount of data in GB allocated for monthly data transfers.
     * </p>
     * 
     * @return The amount of data in GB allocated for monthly data transfers.
     */
    public MonthlyTransfer monthlyTransfer() {
        return monthlyTransfer;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the ports on the instance.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the ports on the instance.
     */
    public List<InstancePortInfo> ports() {
        return ports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((monthlyTransfer() == null) ? 0 : monthlyTransfer().hashCode());
        hashCode = 31 * hashCode + ((ports() == null) ? 0 : ports().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking) obj;
        if (other.monthlyTransfer() == null ^ this.monthlyTransfer() == null) {
            return false;
        }
        if (other.monthlyTransfer() != null && !other.monthlyTransfer().equals(this.monthlyTransfer())) {
            return false;
        }
        if (other.ports() == null ^ this.ports() == null) {
            return false;
        }
        if (other.ports() != null && !other.ports().equals(this.ports())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (monthlyTransfer() != null) {
            sb.append("MonthlyTransfer: ").append(monthlyTransfer()).append(",");
        }
        if (ports() != null) {
            sb.append("Ports: ").append(ports()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceNetworkingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworking> {
        /**
         * <p>
         * The amount of data in GB allocated for monthly data transfers.
         * </p>
         * 
         * @param monthlyTransfer
         *        The amount of data in GB allocated for monthly data transfers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyTransfer(MonthlyTransfer monthlyTransfer);

        /**
         * <p>
         * An array of key-value pairs containing information about the ports on the instance.
         * </p>
         * 
         * @param ports
         *        An array of key-value pairs containing information about the ports on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Collection<InstancePortInfo> ports);

        /**
         * <p>
         * An array of key-value pairs containing information about the ports on the instance.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPorts(java.util.Collection)} or {@link #withPorts(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param ports
         *        An array of key-value pairs containing information about the ports on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(InstancePortInfo... ports);
    }

    private static final class BuilderImpl implements Builder {
        private MonthlyTransfer monthlyTransfer;

        private List<InstancePortInfo> ports;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworking model) {
            setMonthlyTransfer(model.monthlyTransfer);
            setPorts(model.ports);
        }

        public final MonthlyTransfer getMonthlyTransfer() {
            return monthlyTransfer;
        }

        @Override
        public final Builder monthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
            return this;
        }

        public final void setMonthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
        }

        public final Collection<InstancePortInfo> getPorts() {
            return ports;
        }

        @Override
        public final Builder ports(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(InstancePortInfo... ports) {
            if (this.ports == null) {
                this.ports = new ArrayList<>(ports.length);
            }
            for (InstancePortInfo e : ports) {
                this.ports.add(e);
            }
            return this;
        }

        public final void setPorts(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
        }

        @SafeVarargs
        public final void setPorts(InstancePortInfo... ports) {
            if (this.ports == null) {
                this.ports = new ArrayList<>(ports.length);
            }
            for (InstancePortInfo e : ports) {
                this.ports.add(e);
            }
        }

        @Override
        public InstanceNetworking build() {
            return new InstanceNetworking(this);
        }
    }
}
