/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstancePortInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about the instance ports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancePortInfo implements StructuredPojo, ToCopyableBuilder<InstancePortInfo.Builder, InstancePortInfo> {
    private final Integer fromPort;

    private final Integer toPort;

    private final String protocol;

    private final String accessFrom;

    private final String accessType;

    private final String commonName;

    private final String accessDirection;

    private InstancePortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.accessFrom = builder.accessFrom;
        this.accessType = builder.accessType;
        this.commonName = builder.commonName;
        this.accessDirection = builder.accessDirection;
    }

    /**
     * <p>
     * The first port in the range.
     * </p>
     * 
     * @return The first port in the range.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The last port in the range.
     * </p>
     * 
     * @return The last port in the range.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The protocol being used. Can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of
     * streamed data between applications running on hosts communicating by an IP network. If you have an application
     * that doesn't require reliable data stream service, use UDP instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> - All transport layer protocol types. For more general information, see <a
     * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to
     * other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission
     * channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides
     * a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable
     * data stream service, use TCP instead.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The protocol being used. Can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
     *         delivery of streamed data between applications running on hosts communicating by an IP network. If you
     *         have an application that doesn't require reliable data stream service, use UDP instead.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> - All transport layer protocol types. For more general information, see <a
     *         href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
     *         datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to
     *         set up transmission channels or data paths. Applications that don't require reliable data stream service
     *         can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over
     *         reliability. If you do require reliable data stream service, use TCP instead.
     *         </p>
     *         </li>
     * @see NetworkProtocol
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The location from which access is allowed (e.g., <code>Anywhere (0.0.0.0/0)</code>).
     * </p>
     * 
     * @return The location from which access is allowed (e.g., <code>Anywhere (0.0.0.0/0)</code>).
     */
    public String accessFrom() {
        return accessFrom;
    }

    /**
     * <p>
     * The type of access (<code>Public</code> or <code>Private</code>).
     * </p>
     * 
     * @return The type of access (<code>Public</code> or <code>Private</code>).
     * @see PortAccessType
     */
    public String accessType() {
        return accessType;
    }

    /**
     * <p>
     * The common name.
     * </p>
     * 
     * @return The common name.
     */
    public String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The access direction (<code>inbound</code> or <code>outbound</code>).
     * </p>
     * 
     * @return The access direction (<code>inbound</code> or <code>outbound</code>).
     * @see AccessDirection
     */
    public String accessDirection() {
        return accessDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        hashCode = 31 * hashCode + ((accessFrom() == null) ? 0 : accessFrom().hashCode());
        hashCode = 31 * hashCode + ((accessType() == null) ? 0 : accessType().hashCode());
        hashCode = 31 * hashCode + ((commonName() == null) ? 0 : commonName().hashCode());
        hashCode = 31 * hashCode + ((accessDirection() == null) ? 0 : accessDirection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortInfo)) {
            return false;
        }
        InstancePortInfo other = (InstancePortInfo) obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.accessFrom() == null ^ this.accessFrom() == null) {
            return false;
        }
        if (other.accessFrom() != null && !other.accessFrom().equals(this.accessFrom())) {
            return false;
        }
        if (other.accessType() == null ^ this.accessType() == null) {
            return false;
        }
        if (other.accessType() != null && !other.accessType().equals(this.accessType())) {
            return false;
        }
        if (other.commonName() == null ^ this.commonName() == null) {
            return false;
        }
        if (other.commonName() != null && !other.commonName().equals(this.commonName())) {
            return false;
        }
        if (other.accessDirection() == null ^ this.accessDirection() == null) {
            return false;
        }
        if (other.accessDirection() != null && !other.accessDirection().equals(this.accessDirection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        if (accessFrom() != null) {
            sb.append("AccessFrom: ").append(accessFrom()).append(",");
        }
        if (accessType() != null) {
            sb.append("AccessType: ").append(accessType()).append(",");
        }
        if (commonName() != null) {
            sb.append("CommonName: ").append(commonName()).append(",");
        }
        if (accessDirection() != null) {
            sb.append("AccessDirection: ").append(accessDirection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancePortInfo> {
        /**
         * <p>
         * The first port in the range.
         * </p>
         * 
         * @param fromPort
         *        The first port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The last port in the range.
         * </p>
         * 
         * @param toPort
         *        The last port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(NetworkProtocol protocol);

        /**
         * <p>
         * The location from which access is allowed (e.g., <code>Anywhere (0.0.0.0/0)</code>).
         * </p>
         * 
         * @param accessFrom
         *        The location from which access is allowed (e.g., <code>Anywhere (0.0.0.0/0)</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessFrom(String accessFrom);

        /**
         * <p>
         * The type of access (<code>Public</code> or <code>Private</code>).
         * </p>
         * 
         * @param accessType
         *        The type of access (<code>Public</code> or <code>Private</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortAccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of access (<code>Public</code> or <code>Private</code>).
         * </p>
         * 
         * @param accessType
         *        The type of access (<code>Public</code> or <code>Private</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortAccessType
         */
        Builder accessType(PortAccessType accessType);

        /**
         * <p>
         * The common name.
         * </p>
         * 
         * @param commonName
         *        The common name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The access direction (<code>inbound</code> or <code>outbound</code>).
         * </p>
         * 
         * @param accessDirection
         *        The access direction (<code>inbound</code> or <code>outbound</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessDirection
         */
        Builder accessDirection(String accessDirection);

        /**
         * <p>
         * The access direction (<code>inbound</code> or <code>outbound</code>).
         * </p>
         * 
         * @param accessDirection
         *        The access direction (<code>inbound</code> or <code>outbound</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessDirection
         */
        Builder accessDirection(AccessDirection accessDirection);
    }

    private static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private String protocol;

        private String accessFrom;

        private String accessType;

        private String commonName;

        private String accessDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortInfo model) {
            setFromPort(model.fromPort);
            setToPort(model.toPort);
            setProtocol(model.protocol);
            setAccessFrom(model.accessFrom);
            setAccessType(model.accessType);
            setCommonName(model.commonName);
            setAccessDirection(model.accessDirection);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
        }

        public final String getAccessFrom() {
            return accessFrom;
        }

        @Override
        public final Builder accessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
            return this;
        }

        public final void setAccessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
        }

        public final String getAccessType() {
            return accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(PortAccessType accessType) {
            this.accessType(accessType.toString());
            return this;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public final void setAccessType(PortAccessType accessType) {
            this.accessType(accessType.toString());
        }

        public final String getCommonName() {
            return commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getAccessDirection() {
            return accessDirection;
        }

        @Override
        public final Builder accessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
            return this;
        }

        @Override
        public final Builder accessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection.toString());
            return this;
        }

        public final void setAccessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
        }

        public final void setAccessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection.toString());
        }

        @Override
        public InstancePortInfo build() {
            return new InstancePortInfo(this);
        }
    }
}
