/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lightsail.transform.KeyPairMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the SSH key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyPair implements StructuredPojo, ToCopyableBuilder<KeyPair.Builder, KeyPair> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Date createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String fingerprint;

    private KeyPair(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.fingerprint = builder.fingerprint;
    }

    /**
     * <p>
     * The friendly name of the SSH key pair.
     * </p>
     * 
     * @return The friendly name of the SSH key pair.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the key pair (e.g.,
     * <code>arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the key pair (e.g.,
     *         <code>arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).
     */
    public Date createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region name and Availability Zone where the key pair was created.
     * </p>
     * 
     * @return The region name and Availability Zone where the key pair was created.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The resource type (usually <code>KeyPair</code>).
     * </p>
     * 
     * @return The resource type (usually <code>KeyPair</code>).
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The RSA fingerprint of the key pair.
     * </p>
     * 
     * @return The RSA fingerprint of the key pair.
     */
    public String fingerprint() {
        return fingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((supportCode() == null) ? 0 : supportCode().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((fingerprint() == null) ? 0 : fingerprint().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.fingerprint() == null ^ this.fingerprint() == null) {
            return false;
        }
        if (other.fingerprint() != null && !other.fingerprint().equals(this.fingerprint())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (fingerprint() != null) {
            sb.append("Fingerprint: ").append(fingerprint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyPair> {
        /**
         * <p>
         * The friendly name of the SSH key pair.
         * </p>
         * 
         * @param name
         *        The friendly name of the SSH key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the key pair (e.g.,
         * <code>arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the key pair (e.g.,
         *        <code>arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Date createdAt);

        /**
         * <p>
         * The region name and Availability Zone where the key pair was created.
         * </p>
         * 
         * @param location
         *        The region name and Availability Zone where the key pair was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The resource type (usually <code>KeyPair</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (usually <code>KeyPair</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type (usually <code>KeyPair</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (usually <code>KeyPair</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The RSA fingerprint of the key pair.
         * </p>
         * 
         * @param fingerprint
         *        The RSA fingerprint of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fingerprint(String fingerprint);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Date createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String fingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            setName(model.name);
            setArn(model.arn);
            setSupportCode(model.supportCode);
            setCreatedAt(model.createdAt);
            setLocation(model.location);
            setResourceType(model.resourceType);
            setFingerprint(model.fingerprint);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Date getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
        }

        public final ResourceLocation getLocation() {
            return location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getFingerprint() {
            return fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public KeyPair build() {
            return new KeyPair(this);
        }
    }
}
