/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lightsail.transform.MetricDatapointMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metric data point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricDatapoint implements StructuredPojo, ToCopyableBuilder<MetricDatapoint.Builder, MetricDatapoint> {
    private final Double average;

    private final Double maximum;

    private final Double minimum;

    private final Double sampleCount;

    private final Double sum;

    private final Date timestamp;

    private final String unit;

    private MetricDatapoint(BuilderImpl builder) {
        this.average = builder.average;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.timestamp = builder.timestamp;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The average.
     * </p>
     * 
     * @return The average.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The maximum.
     * </p>
     * 
     * @return The maximum.
     */
    public Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The minimum.
     * </p>
     * 
     * @return The minimum.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The sample count.
     * </p>
     * 
     * @return The sample count.
     */
    public Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The sum.
     * </p>
     * 
     * @return The sum.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The timestamp (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp (e.g., <code>1479816991.349</code>).
     */
    public Date timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The unit.
     * </p>
     * 
     * @return The unit.
     * @see MetricUnit
     */
    public String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((average() == null) ? 0 : average().hashCode());
        hashCode = 31 * hashCode + ((maximum() == null) ? 0 : maximum().hashCode());
        hashCode = 31 * hashCode + ((minimum() == null) ? 0 : minimum().hashCode());
        hashCode = 31 * hashCode + ((sampleCount() == null) ? 0 : sampleCount().hashCode());
        hashCode = 31 * hashCode + ((sum() == null) ? 0 : sum().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatapoint)) {
            return false;
        }
        MetricDatapoint other = (MetricDatapoint) obj;
        if (other.average() == null ^ this.average() == null) {
            return false;
        }
        if (other.average() != null && !other.average().equals(this.average())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (average() != null) {
            sb.append("Average: ").append(average()).append(",");
        }
        if (maximum() != null) {
            sb.append("Maximum: ").append(maximum()).append(",");
        }
        if (minimum() != null) {
            sb.append("Minimum: ").append(minimum()).append(",");
        }
        if (sampleCount() != null) {
            sb.append("SampleCount: ").append(sampleCount()).append(",");
        }
        if (sum() != null) {
            sb.append("Sum: ").append(sum()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricDatapointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MetricDatapoint> {
        /**
         * <p>
         * The average.
         * </p>
         * 
         * @param average
         *        The average.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The maximum.
         * </p>
         * 
         * @param maximum
         *        The maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The minimum.
         * </p>
         * 
         * @param minimum
         *        The minimum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The sample count.
         * </p>
         * 
         * @param sampleCount
         *        The sample count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The sum.
         * </p>
         * 
         * @param sum
         *        The sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The timestamp (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param timestamp
         *        The timestamp (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Date timestamp);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);
    }

    private static final class BuilderImpl implements Builder {
        private Double average;

        private Double maximum;

        private Double minimum;

        private Double sampleCount;

        private Double sum;

        private Date timestamp;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatapoint model) {
            setAverage(model.average);
            setMaximum(model.maximum);
            setMinimum(model.minimum);
            setSampleCount(model.sampleCount);
            setSum(model.sum);
            setTimestamp(model.timestamp);
            setUnit(model.unit);
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Date getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(MetricUnit unit) {
            this.unit(unit.toString());
        }

        @Override
        public MetricDatapoint build() {
            return new MetricDatapoint(this);
        }
    }
}
