/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.PortInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about the ports on your virtual private server (or <i>instance</i>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PortInfo implements StructuredPojo, ToCopyableBuilder<PortInfo.Builder, PortInfo> {
    private final Integer fromPort;

    private final Integer toPort;

    private final String protocol;

    private PortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The first port in the range.
     * </p>
     * 
     * @return The first port in the range.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The last port in the range.
     * </p>
     * 
     * @return The last port in the range.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * 
     * @return The protocol.
     * @see NetworkProtocol
     */
    public String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortInfo)) {
            return false;
        }
        PortInfo other = (PortInfo) obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PortInfo> {
        /**
         * <p>
         * The first port in the range.
         * </p>
         * 
         * @param fromPort
         *        The first port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The last port in the range.
         * </p>
         * 
         * @param toPort
         *        The last port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(NetworkProtocol protocol);
    }

    private static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(PortInfo model) {
            setFromPort(model.fromPort);
            setToPort(model.toPort);
            setProtocol(model.protocol);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
        }

        @Override
        public PortInfo build() {
            return new PortInfo(this);
        }
    }
}
