/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Bundle JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BundleUnmarshaller implements Unmarshaller<Bundle, JsonUnmarshallerContext> {

    public Bundle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bundle.Builder bundleBuilder = Bundle.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("price", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.price(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("cpuCount", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.cpuCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("diskSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.diskSizeInGb(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.bundleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.instanceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.isActive(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("power", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.power(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ramSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.ramSizeInGb(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("transferPerMonthInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.transferPerMonthInGb(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return bundleBuilder.build();
    }

    private static BundleUnmarshaller INSTANCE;

    public static BundleUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new BundleUnmarshaller();
        return INSTANCE;
    }
}