/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.BundleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Bundle
implements StructuredPojo,
ToCopyableBuilder<Builder, Bundle> {
    private final Float price;
    private final Integer cpuCount;
    private final Integer diskSizeInGb;
    private final String bundleId;
    private final String instanceType;
    private final Boolean isActive;
    private final String name;
    private final Integer power;
    private final Float ramSizeInGb;
    private final Integer transferPerMonthInGb;

    private Bundle(BuilderImpl builder) {
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.bundleId = builder.bundleId;
        this.instanceType = builder.instanceType;
        this.isActive = builder.isActive;
        this.name = builder.name;
        this.power = builder.power;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
    }

    public Float price() {
        return this.price;
    }

    public Integer cpuCount() {
        return this.cpuCount;
    }

    public Integer diskSizeInGb() {
        return this.diskSizeInGb;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public String name() {
        return this.name;
    }

    public Integer power() {
        return this.power;
    }

    public Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Integer transferPerMonthInGb() {
        return this.transferPerMonthInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.price() == null ? 0 : this.price().hashCode());
        hashCode = 31 * hashCode + (this.cpuCount() == null ? 0 : this.cpuCount().hashCode());
        hashCode = 31 * hashCode + (this.diskSizeInGb() == null ? 0 : this.diskSizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.bundleId() == null ? 0 : this.bundleId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.isActive() == null ? 0 : this.isActive().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.power() == null ? 0 : this.power().hashCode());
        hashCode = 31 * hashCode + (this.ramSizeInGb() == null ? 0 : this.ramSizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.transferPerMonthInGb() == null ? 0 : this.transferPerMonthInGb().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle)obj;
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        if (other.price() != null && !other.price().equals(this.price())) {
            return false;
        }
        if (other.cpuCount() == null ^ this.cpuCount() == null) {
            return false;
        }
        if (other.cpuCount() != null && !other.cpuCount().equals(this.cpuCount())) {
            return false;
        }
        if (other.diskSizeInGb() == null ^ this.diskSizeInGb() == null) {
            return false;
        }
        if (other.diskSizeInGb() != null && !other.diskSizeInGb().equals(this.diskSizeInGb())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.isActive() == null ^ this.isActive() == null) {
            return false;
        }
        if (other.isActive() != null && !other.isActive().equals(this.isActive())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.power() == null ^ this.power() == null) {
            return false;
        }
        if (other.power() != null && !other.power().equals(this.power())) {
            return false;
        }
        if (other.ramSizeInGb() == null ^ this.ramSizeInGb() == null) {
            return false;
        }
        if (other.ramSizeInGb() != null && !other.ramSizeInGb().equals(this.ramSizeInGb())) {
            return false;
        }
        if (other.transferPerMonthInGb() == null ^ this.transferPerMonthInGb() == null) {
            return false;
        }
        return other.transferPerMonthInGb() == null || other.transferPerMonthInGb().equals(this.transferPerMonthInGb());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.price() != null) {
            sb.append("Price: ").append(this.price()).append(",");
        }
        if (this.cpuCount() != null) {
            sb.append("CpuCount: ").append(this.cpuCount()).append(",");
        }
        if (this.diskSizeInGb() != null) {
            sb.append("DiskSizeInGb: ").append(this.diskSizeInGb()).append(",");
        }
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.isActive() != null) {
            sb.append("IsActive: ").append(this.isActive()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.power() != null) {
            sb.append("Power: ").append(this.power()).append(",");
        }
        if (this.ramSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(this.ramSizeInGb()).append(",");
        }
        if (this.transferPerMonthInGb() != null) {
            sb.append("TransferPerMonthInGb: ").append(this.transferPerMonthInGb()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BundleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Float price;
        private Integer cpuCount;
        private Integer diskSizeInGb;
        private String bundleId;
        private String instanceType;
        private Boolean isActive;
        private String name;
        private Integer power;
        private Float ramSizeInGb;
        private Integer transferPerMonthInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(Bundle model) {
            this.setPrice(model.price);
            this.setCpuCount(model.cpuCount);
            this.setDiskSizeInGb(model.diskSizeInGb);
            this.setBundleId(model.bundleId);
            this.setInstanceType(model.instanceType);
            this.setIsActive(model.isActive);
            this.setName(model.name);
            this.setPower(model.power);
            this.setRamSizeInGb(model.ramSizeInGb);
            this.setTransferPerMonthInGb(model.transferPerMonthInGb);
        }

        public final Float getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Integer getDiskSizeInGb() {
            return this.diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPower() {
            return this.power;
        }

        @Override
        public final Builder power(Integer power) {
            this.power = power;
            return this;
        }

        public final void setPower(Integer power) {
            this.power = power;
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final Integer getTransferPerMonthInGb() {
            return this.transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        public Bundle build() {
            return new Bundle(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Bundle> {
        public Builder price(Float var1);

        public Builder cpuCount(Integer var1);

        public Builder diskSizeInGb(Integer var1);

        public Builder bundleId(String var1);

        public Builder instanceType(String var1);

        public Builder isActive(Boolean var1);

        public Builder name(String var1);

        public Builder power(Integer var1);

        public Builder ramSizeInGb(Float var1);

        public Builder transferPerMonthInGb(Integer var1);
    }
}

