/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateInstancesResponse> {
    private final List<Operation> operations;

    private CreateInstancesResponse(BuilderImpl builder) {
        this.operations = builder.operations;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesResponse)) {
            return false;
        }
        CreateInstancesResponse other = (CreateInstancesResponse)((Object)obj);
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        return other.operations() == null || other.operations().equals(this.operations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Operation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesResponse model) {
            this.setOperations(model.operations);
        }

        public final Collection<Operation> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            if (this.operations == null) {
                this.operations = new ArrayList<Operation>(operations.length);
            }
            for (Operation e : operations) {
                this.operations.add(e);
            }
            return this;
        }

        public final void setOperations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
        }

        @SafeVarargs
        public final void setOperations(Operation ... operations) {
            if (this.operations == null) {
                this.operations = new ArrayList<Operation>(operations.length);
            }
            for (Operation e : operations) {
                this.operations.add(e);
            }
        }

        public CreateInstancesResponse build() {
            return new CreateInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstancesResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);
    }
}

