/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Domain;
import software.amazon.awssdk.services.lightsail.model.DomainListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDomainsResponse> {
    private final List<Domain> domains;
    private final String nextPageToken;

    private GetDomainsResponse(BuilderImpl builder) {
        this.domains = builder.domains;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Domain> domains() {
        return this.domains;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domains() == null ? 0 : this.domains().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainsResponse)) {
            return false;
        }
        GetDomainsResponse other = (GetDomainsResponse)((Object)obj);
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domains() != null) {
            sb.append("Domains: ").append(this.domains()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Domain> domains;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainsResponse model) {
            this.setDomains(model.domains);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<Domain> getDomains() {
            return this.domains;
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain ... domains) {
            if (this.domains == null) {
                this.domains = new ArrayList<Domain>(domains.length);
            }
            for (Domain e : domains) {
                this.domains.add(e);
            }
            return this;
        }

        public final void setDomains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
        }

        @SafeVarargs
        public final void setDomains(Domain ... domains) {
            if (this.domains == null) {
                this.domains = new ArrayList<Domain>(domains.length);
            }
            for (Domain e : domains) {
                this.domains.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetDomainsResponse build() {
            return new GetDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDomainsResponse> {
        public Builder domains(Collection<Domain> var1);

        public Builder domains(Domain ... var1);

        public Builder nextPageToken(String var1);
    }
}

