/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceSnapshotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
    private final List<InstanceSnapshot> instanceSnapshots;
    private final String nextPageToken;

    private GetInstanceSnapshotsResponse(BuilderImpl builder) {
        this.instanceSnapshots = builder.instanceSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<InstanceSnapshot> instanceSnapshots() {
        return this.instanceSnapshots;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceSnapshots() == null ? 0 : this.instanceSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotsResponse)) {
            return false;
        }
        GetInstanceSnapshotsResponse other = (GetInstanceSnapshotsResponse)((Object)obj);
        if (other.instanceSnapshots() == null ^ this.instanceSnapshots() == null) {
            return false;
        }
        if (other.instanceSnapshots() != null && !other.instanceSnapshots().equals(this.instanceSnapshots())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceSnapshots() != null) {
            sb.append("InstanceSnapshots: ").append(this.instanceSnapshots()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceSnapshot> instanceSnapshots;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotsResponse model) {
            this.setInstanceSnapshots(model.instanceSnapshots);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<InstanceSnapshot> getInstanceSnapshots() {
            return this.instanceSnapshots;
        }

        @Override
        public final Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(InstanceSnapshot ... instanceSnapshots) {
            if (this.instanceSnapshots == null) {
                this.instanceSnapshots = new ArrayList<InstanceSnapshot>(instanceSnapshots.length);
            }
            for (InstanceSnapshot e : instanceSnapshots) {
                this.instanceSnapshots.add(e);
            }
            return this;
        }

        public final void setInstanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
        }

        @SafeVarargs
        public final void setInstanceSnapshots(InstanceSnapshot ... instanceSnapshots) {
            if (this.instanceSnapshots == null) {
                this.instanceSnapshots = new ArrayList<InstanceSnapshot>(instanceSnapshots.length);
            }
            for (InstanceSnapshot e : instanceSnapshots) {
                this.instanceSnapshots.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetInstanceSnapshotsResponse build() {
            return new GetInstanceSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
        public Builder instanceSnapshots(Collection<InstanceSnapshot> var1);

        public Builder instanceSnapshots(InstanceSnapshot ... var1);

        public Builder nextPageToken(String var1);
    }
}

