/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfoListCopier;
import software.amazon.awssdk.services.lightsail.model.MonthlyTransfer;
import software.amazon.awssdk.services.lightsail.transform.InstanceNetworkingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceNetworking
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceNetworking> {
    private final MonthlyTransfer monthlyTransfer;
    private final List<InstancePortInfo> ports;

    private InstanceNetworking(BuilderImpl builder) {
        this.monthlyTransfer = builder.monthlyTransfer;
        this.ports = builder.ports;
    }

    public MonthlyTransfer monthlyTransfer() {
        return this.monthlyTransfer;
    }

    public List<InstancePortInfo> ports() {
        return this.ports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.monthlyTransfer() == null ? 0 : this.monthlyTransfer().hashCode());
        hashCode = 31 * hashCode + (this.ports() == null ? 0 : this.ports().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking)obj;
        if (other.monthlyTransfer() == null ^ this.monthlyTransfer() == null) {
            return false;
        }
        if (other.monthlyTransfer() != null && !other.monthlyTransfer().equals(this.monthlyTransfer())) {
            return false;
        }
        if (other.ports() == null ^ this.ports() == null) {
            return false;
        }
        return other.ports() == null || other.ports().equals(this.ports());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.monthlyTransfer() != null) {
            sb.append("MonthlyTransfer: ").append(this.monthlyTransfer()).append(",");
        }
        if (this.ports() != null) {
            sb.append("Ports: ").append(this.ports()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceNetworkingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private MonthlyTransfer monthlyTransfer;
        private List<InstancePortInfo> ports;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworking model) {
            this.setMonthlyTransfer(model.monthlyTransfer);
            this.setPorts(model.ports);
        }

        public final MonthlyTransfer getMonthlyTransfer() {
            return this.monthlyTransfer;
        }

        @Override
        public final Builder monthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
            return this;
        }

        public final void setMonthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
        }

        public final Collection<InstancePortInfo> getPorts() {
            return this.ports;
        }

        @Override
        public final Builder ports(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(InstancePortInfo ... ports) {
            if (this.ports == null) {
                this.ports = new ArrayList<InstancePortInfo>(ports.length);
            }
            for (InstancePortInfo e : ports) {
                this.ports.add(e);
            }
            return this;
        }

        public final void setPorts(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
        }

        @SafeVarargs
        public final void setPorts(InstancePortInfo ... ports) {
            if (this.ports == null) {
                this.ports = new ArrayList<InstancePortInfo>(ports.length);
            }
            for (InstancePortInfo e : ports) {
                this.ports.add(e);
            }
        }

        public InstanceNetworking build() {
            return new InstanceNetworking(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceNetworking> {
        public Builder monthlyTransfer(MonthlyTransfer var1);

        public Builder ports(Collection<InstancePortInfo> var1);

        public Builder ports(InstancePortInfo ... var1);
    }
}

