/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.model.PortState;
import software.amazon.awssdk.services.lightsail.transform.InstancePortStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstancePortState
implements StructuredPojo,
ToCopyableBuilder<Builder, InstancePortState> {
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;
    private final String state;

    private InstancePortState(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.state = builder.state;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String protocol() {
        return this.protocol;
    }

    public String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortState)) {
            return false;
        }
        InstancePortState other = (InstancePortState)obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        return other.state() == null || other.state().equals(this.state());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortState model) {
            this.setFromPort(model.fromPort);
            this.setToPort(model.toPort);
            this.setProtocol(model.protocol);
            this.setState(model.state);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PortState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(PortState state) {
            this.state(state.toString());
        }

        public InstancePortState build() {
            return new InstancePortState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstancePortState> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);

        public Builder state(String var1);

        public Builder state(PortState var1);
    }
}

