/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.AvailabilityZone;
import software.amazon.awssdk.services.lightsail.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.services.lightsail.transform.RegionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Region
implements StructuredPojo,
ToCopyableBuilder<Builder, Region> {
    private final String continentCode;
    private final String description;
    private final String displayName;
    private final String name;
    private final List<AvailabilityZone> availabilityZones;

    private Region(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
    }

    public String continentCode() {
        return this.continentCode;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public String name() {
        return this.name;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.continentCode() == null ? 0 : this.continentCode().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        if (other.continentCode() == null ^ this.continentCode() == null) {
            return false;
        }
        if (other.continentCode() != null && !other.continentCode().equals(this.continentCode())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        return other.availabilityZones() == null || other.availabilityZones().equals(this.availabilityZones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.continentCode() != null) {
            sb.append("ContinentCode: ").append(this.continentCode()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String continentCode;
        private String description;
        private String displayName;
        private String name;
        private List<AvailabilityZone> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            this.setContinentCode(model.continentCode);
            this.setDescription(model.description);
            this.setDisplayName(model.displayName);
            this.setName(model.name);
            this.setAvailabilityZones(model.availabilityZones);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RegionName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setName(RegionName name) {
            this.name(name.toString());
        }

        public final Collection<AvailabilityZone> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new ArrayList<AvailabilityZone>(availabilityZones.length);
            }
            for (AvailabilityZone e : availabilityZones) {
                this.availabilityZones.add(e);
            }
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(AvailabilityZone ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new ArrayList<AvailabilityZone>(availabilityZones.length);
            }
            for (AvailabilityZone e : availabilityZones) {
                this.availabilityZones.add(e);
            }
        }

        public Region build() {
            return new Region(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Region> {
        public Builder continentCode(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder name(String var1);

        public Builder name(RegionName var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);
    }
}

