/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceLocation> {
    private final String availabilityZone;
    private final String regionName;

    private ResourceLocation(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.regionName = builder.regionName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String regionName() {
        return this.regionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.regionName() == null ? 0 : this.regionName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation other = (ResourceLocation)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        return other.regionName() == null || other.regionName().equals(this.regionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.regionName() != null) {
            sb.append("RegionName: ").append(this.regionName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLocation model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setRegionName(model.regionName);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName.toString());
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final void setRegionName(RegionName regionName) {
            this.regionName(regionName.toString());
        }

        public ResourceLocation build() {
            return new ResourceLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceLocation> {
        public Builder availabilityZone(String var1);

        public Builder regionName(String var1);

        public Builder regionName(RegionName var1);
    }
}

