/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails;

@SdkInternalApi
public class InstanceAccessDetailsMarshaller {
    private static final MarshallingInfo<String> CERTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certKey").build();
    private static final MarshallingInfo<Date> EXPIRESAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateKey").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").build();
    private static final InstanceAccessDetailsMarshaller instance = new InstanceAccessDetailsMarshaller();

    public static InstanceAccessDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceAccessDetails instanceAccessDetails, ProtocolMarshaller protocolMarshaller) {
        if (instanceAccessDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceAccessDetails.certKey(), CERTKEY_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.expiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.protocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceAccessDetails.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

