/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshot;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DiskSnapshotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<String> PROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progress").isBinary(false).build();
    private static final MarshallingInfo<String> FROMDISKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskName").isBinary(false).build();
    private static final MarshallingInfo<String> FROMDISKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskArn").isBinary(false).build();
    private static final DiskSnapshotMarshaller INSTANCE = new DiskSnapshotMarshaller();

    private DiskSnapshotMarshaller() {
    }

    public static DiskSnapshotMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DiskSnapshot diskSnapshot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)diskSnapshot, (String)"diskSnapshot");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)diskSnapshot.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.sizeInGb(), SIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.progress(), PROGRESS_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.fromDiskName(), FROMDISKNAME_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.fromDiskArn(), FROMDISKARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

