/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiskSnapshotsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDiskSnapshotsResponse.Builder, GetDiskSnapshotsResponse> {
    private final List<DiskSnapshot> diskSnapshots;

    private final String nextPageToken;

    private GetDiskSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.diskSnapshots = builder.diskSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of objects containing information about all block storage disk snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects containing information about all block storage disk snapshots.
     */
    public List<DiskSnapshot> diskSnapshots() {
        return diskSnapshots;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your GetDiskSnapshots request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your GetDiskSnapshots request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotsResponse)) {
            return false;
        }
        GetDiskSnapshotsResponse other = (GetDiskSnapshotsResponse) obj;
        return Objects.equals(diskSnapshots(), other.diskSnapshots()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDiskSnapshotsResponse").add("DiskSnapshots", diskSnapshots())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskSnapshots":
            return Optional.ofNullable(clazz.cast(diskSnapshots()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetDiskSnapshotsResponse> {
        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * 
         * @param diskSnapshots
         *        An array of objects containing information about all block storage disk snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots);

        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * 
         * @param diskSnapshots
         *        An array of objects containing information about all block storage disk snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshots(DiskSnapshot... diskSnapshots);

        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DiskSnapshot>.Builder} avoiding the need to
         * create one manually via {@link List<DiskSnapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DiskSnapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #diskSnapshots(List<DiskSnapshot>)}.
         * 
         * @param diskSnapshots
         *        a consumer that will call methods on {@link List<DiskSnapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskSnapshots(List<DiskSnapshot>)
         */
        Builder diskSnapshots(Consumer<DiskSnapshot.Builder>... diskSnapshots);

        /**
         * <p>
         * A token used for advancing to the next page of results from your GetDiskSnapshots request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your GetDiskSnapshots request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<DiskSnapshot> diskSnapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotsResponse model) {
            super(model);
            diskSnapshots(model.diskSnapshots);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<DiskSnapshot.Builder> getDiskSnapshots() {
            return diskSnapshots != null ? diskSnapshots.stream().map(DiskSnapshot::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copy(diskSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(DiskSnapshot... diskSnapshots) {
            diskSnapshots(Arrays.asList(diskSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(Consumer<DiskSnapshot.Builder>... diskSnapshots) {
            diskSnapshots(Stream.of(diskSnapshots).map(c -> DiskSnapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDiskSnapshots(Collection<DiskSnapshot.BuilderImpl> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copyFromBuilder(diskSnapshots);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDiskSnapshotsResponse build() {
            return new GetDiskSnapshotsResponse(this);
        }
    }
}
