/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegionsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRegionsResponse.Builder, GetRegionsResponse> {
    private final List<Region> regions;

    private GetRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.regions = builder.regions;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about your get regions request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about your get regions request.
     */
    public List<Region> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsResponse)) {
            return false;
        }
        GetRegionsResponse other = (GetRegionsResponse) obj;
        return Objects.equals(regions(), other.regions());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRegionsResponse").add("Regions", regions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetRegionsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about your get regions request.
         * </p>
         * 
         * @param regions
         *        An array of key-value pairs containing information about your get regions request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<Region> regions);

        /**
         * <p>
         * An array of key-value pairs containing information about your get regions request.
         * </p>
         * 
         * @param regions
         *        An array of key-value pairs containing information about your get regions request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Region... regions);

        /**
         * <p>
         * An array of key-value pairs containing information about your get regions request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Region>.Builder} avoiding the need to
         * create one manually via {@link List<Region>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Region>.Builder#build()} is called immediately and its
         * result is passed to {@link #regions(List<Region>)}.
         * 
         * @param regions
         *        a consumer that will call methods on {@link List<Region>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regions(List<Region>)
         */
        Builder regions(Consumer<Region.Builder>... regions);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Region> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsResponse model) {
            super(model);
            regions(model.regions);
        }

        public final Collection<Region.Builder> getRegions() {
            return regions != null ? regions.stream().map(Region::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder>... regions) {
            regions(Stream.of(regions).map(c -> Region.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionListCopier.copyFromBuilder(regions);
        }

        @Override
        public GetRegionsResponse build() {
            return new GetRegionsResponse(this);
        }
    }
}
