/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInstancePublicPortsRequest extends LightsailRequest implements
        ToCopyableBuilder<PutInstancePublicPortsRequest.Builder, PutInstancePublicPortsRequest> {
    private final List<PortInfo> portInfos;

    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * Specifies information about the public port(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies information about the public port(s).
     */
    public List<PortInfo> portInfos() {
        return portInfos;
    }

    /**
     * <p>
     * The Lightsail instance name of the public port(s) you are setting.
     * </p>
     * 
     * @return The Lightsail instance name of the public port(s) you are setting.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portInfos());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest) obj;
        return Objects.equals(portInfos(), other.portInfos()) && Objects.equals(instanceName(), other.instanceName());
    }

    @Override
    public String toString() {
        return ToString.builder("PutInstancePublicPortsRequest").add("PortInfos", portInfos())
                .add("InstanceName", instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portInfos":
            return Optional.ofNullable(clazz.cast(portInfos()));
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        /**
         * <p>
         * Specifies information about the public port(s).
         * </p>
         * 
         * @param portInfos
         *        Specifies information about the public port(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(Collection<PortInfo> portInfos);

        /**
         * <p>
         * Specifies information about the public port(s).
         * </p>
         * 
         * @param portInfos
         *        Specifies information about the public port(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(PortInfo... portInfos);

        /**
         * <p>
         * Specifies information about the public port(s).
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortInfo>.Builder} avoiding the need to
         * create one manually via {@link List<PortInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #portInfos(List<PortInfo>)}.
         * 
         * @param portInfos
         *        a consumer that will call methods on {@link List<PortInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portInfos(List<PortInfo>)
         */
        Builder portInfos(Consumer<PortInfo.Builder>... portInfos);

        /**
         * <p>
         * The Lightsail instance name of the public port(s) you are setting.
         * </p>
         * 
         * @param instanceName
         *        The Lightsail instance name of the public port(s) you are setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<PortInfo> portInfos = DefaultSdkAutoConstructList.getInstance();

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            super(model);
            portInfos(model.portInfos);
            instanceName(model.instanceName);
        }

        public final Collection<PortInfo.Builder> getPortInfos() {
            return portInfos != null ? portInfos.stream().map(PortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo... portInfos) {
            portInfos(Arrays.asList(portInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(Consumer<PortInfo.Builder>... portInfos) {
            portInfos(Stream.of(portInfos).map(c -> PortInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo.BuilderImpl> portInfos) {
            this.portInfos = PortInfoListCopier.copyFromBuilder(portInfos);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }
    }
}
