/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInstancePublicPortsResponse extends LightsailResponse implements
        ToCopyableBuilder<PutInstancePublicPortsResponse.Builder, PutInstancePublicPortsResponse> {
    private final Operation operation;

    private PutInstancePublicPortsResponse(BuilderImpl builder) {
        super(builder);
        this.operation = builder.operation;
    }

    /**
     * <p>
     * Describes metadata about the operation you just executed.
     * </p>
     * 
     * @return Describes metadata about the operation you just executed.
     */
    public Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsResponse)) {
            return false;
        }
        PutInstancePublicPortsResponse other = (PutInstancePublicPortsResponse) obj;
        return Objects.equals(operation(), other.operation());
    }

    @Override
    public String toString() {
        return ToString.builder("PutInstancePublicPortsResponse").add("Operation", operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, PutInstancePublicPortsResponse> {
        /**
         * <p>
         * Describes metadata about the operation you just executed.
         * </p>
         * 
         * @param operation
         *        Describes metadata about the operation you just executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * Describes metadata about the operation you just executed.
         * </p>
         * This is a convenience that creates an instance of the {@link Operation.Builder} avoiding the need to create
         * one manually via {@link Operation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsResponse model) {
            super(model);
            operation(model.operation);
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public PutInstancePublicPortsResponse build() {
            return new PutInstancePublicPortsResponse(this);
        }
    }
}
