/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInstanceRequest extends LightsailRequest implements
        ToCopyableBuilder<StopInstanceRequest.Builder, StopInstanceRequest> {
    private final String instanceName;

    private final Boolean force;

    private StopInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The name of the instance (a virtual private server) to stop.
     * </p>
     * 
     * @return The name of the instance (a virtual private server) to stop.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * When set to <code>True</code>, forces a Lightsail instance that is stuck in a <code>stopping</code> state to
     * stop.
     * </p>
     * <important>
     * <p>
     * Only use the <code>force</code> parameter if your instance is stuck in the <code>stopping</code> state. In any
     * other state, your instance should stop normally without adding this parameter to your API request.
     * </p>
     * </important>
     * 
     * @return When set to <code>True</code>, forces a Lightsail instance that is stuck in a <code>stopping</code> state
     *         to stop.</p> <important>
     *         <p>
     *         Only use the <code>force</code> parameter if your instance is stuck in the <code>stopping</code> state.
     *         In any other state, your instance should stop normally without adding this parameter to your API request.
     *         </p>
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstanceRequest)) {
            return false;
        }
        StopInstanceRequest other = (StopInstanceRequest) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(force(), other.force());
    }

    @Override
    public String toString() {
        return ToString.builder("StopInstanceRequest").add("InstanceName", instanceName()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, StopInstanceRequest> {
        /**
         * <p>
         * The name of the instance (a virtual private server) to stop.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance (a virtual private server) to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * When set to <code>True</code>, forces a Lightsail instance that is stuck in a <code>stopping</code> state to
         * stop.
         * </p>
         * <important>
         * <p>
         * Only use the <code>force</code> parameter if your instance is stuck in the <code>stopping</code> state. In
         * any other state, your instance should stop normally without adding this parameter to your API request.
         * </p>
         * </important>
         * 
         * @param force
         *        When set to <code>True</code>, forces a Lightsail instance that is stuck in a <code>stopping</code>
         *        state to stop.</p> <important>
         *        <p>
         *        Only use the <code>force</code> parameter if your instance is stuck in the <code>stopping</code>
         *        state. In any other state, your instance should stop normally without adding this parameter to your
         *        API request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstanceRequest model) {
            super(model);
            instanceName(model.instanceName);
            force(model.force);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopInstanceRequest build() {
            return new StopInstanceRequest(this);
        }
    }
}
