/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Blueprint JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BlueprintUnmarshaller implements Unmarshaller<Blueprint, JsonUnmarshallerContext> {

    public Blueprint unmarshall(JsonUnmarshallerContext context) throws Exception {
        Blueprint.Builder blueprintBuilder = Blueprint.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("blueprintId", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.blueprintId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("group", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.group(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.isActive(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("minPower", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.minPower(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("versionCode", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.versionCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("productUrl", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.productUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("licenseUrl", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.licenseUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("platform", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.platform(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return blueprintBuilder.build();
    }

    private static final BlueprintUnmarshaller INSTANCE = new BlueprintUnmarshaller();

    public static BlueprintUnmarshaller getInstance() {
        return INSTANCE;
    }
}
