/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Bundle;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Bundle} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BundleMarshaller {
    private static final MarshallingInfo<Float> PRICE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("price").isBinary(false).build();

    private static final MarshallingInfo<Integer> CPUCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> DISKSIZEINGB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskSizeInGb").isBinary(false).build();

    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<Integer> POWER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("power").isBinary(false).build();

    private static final MarshallingInfo<Float> RAMSIZEINGB_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramSizeInGb").isBinary(false).build();

    private static final MarshallingInfo<Integer> TRANSFERPERMONTHINGB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferPerMonthInGb").isBinary(false).build();

    private static final MarshallingInfo<List> SUPPORTEDPLATFORMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedPlatforms").isBinary(false).build();

    private static final BundleMarshaller INSTANCE = new BundleMarshaller();

    private BundleMarshaller() {
    }

    public static BundleMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Bundle bundle, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(bundle, "bundle");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(bundle.price(), PRICE_BINDING);
            protocolMarshaller.marshall(bundle.cpuCount(), CPUCOUNT_BINDING);
            protocolMarshaller.marshall(bundle.diskSizeInGb(), DISKSIZEINGB_BINDING);
            protocolMarshaller.marshall(bundle.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall(bundle.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(bundle.isActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall(bundle.name(), NAME_BINDING);
            protocolMarshaller.marshall(bundle.power(), POWER_BINDING);
            protocolMarshaller.marshall(bundle.ramSizeInGb(), RAMSIZEINGB_BINDING);
            protocolMarshaller.marshall(bundle.transferPerMonthInGb(), TRANSFERPERMONTHINGB_BINDING);
            protocolMarshaller.marshall(bundle.supportedPlatformsAsStrings(), SUPPORTEDPLATFORMS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
