/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateInstancesFromSnapshotRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateInstancesFromSnapshotRequestModelMarshaller {
    private static final MarshallingInfo<List> INSTANCENAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceNames").isBinary(false).build();

    private static final MarshallingInfo<Map> ATTACHEDDISKMAPPING_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedDiskMapping").isBinary(false).build();

    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCESNAPSHOTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceSnapshotName").isBinary(false).build();

    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();

    private static final MarshallingInfo<String> USERDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userData").isBinary(false).build();

    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").isBinary(false).build();

    private static final CreateInstancesFromSnapshotRequestModelMarshaller INSTANCE = new CreateInstancesFromSnapshotRequestModelMarshaller();

    private CreateInstancesFromSnapshotRequestModelMarshaller() {
    }

    public static CreateInstancesFromSnapshotRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createInstancesFromSnapshotRequest, "createInstancesFromSnapshotRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.instanceNames(), INSTANCENAMES_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.attachedDiskMapping(), ATTACHEDDISKMAPPING_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.instanceSnapshotName(), INSTANCESNAPSHOTNAME_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.userData(), USERDATA_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.keyPairName(), KEYPAIRNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
