/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstanceAccessDetails} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceAccessDetailsMarshaller {
    private static final MarshallingInfo<String> CERTKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certKey").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXPIRESAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").isBinary(false).build();

    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").isBinary(false).build();

    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PASSWORDDATA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passwordData")
            .isBinary(false).build();

    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateKey").isBinary(false).build();

    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();

    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();

    private static final InstanceAccessDetailsMarshaller INSTANCE = new InstanceAccessDetailsMarshaller();

    private InstanceAccessDetailsMarshaller() {
    }

    public static InstanceAccessDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstanceAccessDetails instanceAccessDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instanceAccessDetails, "instanceAccessDetails");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceAccessDetails.certKey(), CERTKEY_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.expiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.passwordData(), PASSWORDDATA_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.protocolAsString(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall(instanceAccessDetails.username(), USERNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
