/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstanceSnapshot} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceSnapshotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();

    private static final MarshallingInfo<String> PROGRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progress").isBinary(false).build();

    private static final MarshallingInfo<List> FROMATTACHEDDISKS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromAttachedDisks").isBinary(false).build();

    private static final MarshallingInfo<String> FROMINSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromInstanceName").isBinary(false).build();

    private static final MarshallingInfo<String> FROMINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromInstanceArn").isBinary(false).build();

    private static final MarshallingInfo<String> FROMBLUEPRINTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromBlueprintId").isBinary(false).build();

    private static final MarshallingInfo<String> FROMBUNDLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromBundleId").isBinary(false).build();

    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").isBinary(false).build();

    private static final InstanceSnapshotMarshaller INSTANCE = new InstanceSnapshotMarshaller();

    private InstanceSnapshotMarshaller() {
    }

    public static InstanceSnapshotMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstanceSnapshot instanceSnapshot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instanceSnapshot, "instanceSnapshot");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceSnapshot.name(), NAME_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.arn(), ARN_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.progress(), PROGRESS_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromAttachedDisks(), FROMATTACHEDDISKS_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromInstanceName(), FROMINSTANCENAME_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromInstanceArn(), FROMINSTANCEARN_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromBlueprintId(), FROMBLUEPRINTID_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromBundleId(), FROMBUNDLEID_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.sizeInGb(), SIZEINGB_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
