/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LightsailAsyncClient}.
 *
 * @see LightsailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLightsailAsyncClient implements LightsailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLightsailAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultLightsailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = init(false);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     *
     * @param allocateStaticIpRequest
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        try {

            HttpResponseHandler<AllocateStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AllocateStaticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AllocateStaticIpRequest, AllocateStaticIpResponse>()
                    .withMarshaller(new AllocateStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(allocateStaticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     *
     * @param attachDiskRequest
     * @return A Java Future containing the result of the AttachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        try {

            HttpResponseHandler<AttachDiskResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AttachDiskResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AttachDiskRequest, AttachDiskResponse>()
                    .withMarshaller(new AttachDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachDiskRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     * @return A Java Future containing the result of the AttachInstancesToLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(
            AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        try {

            HttpResponseHandler<AttachInstancesToLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AttachInstancesToLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AttachInstancesToLoadBalancerRequest, AttachInstancesToLoadBalancerResponse>()
                            .withMarshaller(new AttachInstancesToLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachInstancesToLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> operation with
     * the non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(
            AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        try {

            HttpResponseHandler<AttachLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(
                            new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                            new AttachLoadBalancerTlsCertificateResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AttachLoadBalancerTlsCertificateRequest, AttachLoadBalancerTlsCertificateResponse>()
                            .withMarshaller(new AttachLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachLoadBalancerTlsCertificateRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     *
     * @param attachStaticIpRequest
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        try {

            HttpResponseHandler<AttachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AttachStaticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AttachStaticIpRequest, AttachStaticIpResponse>()
                    .withMarshaller(new AttachStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachStaticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        try {

            HttpResponseHandler<CloseInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CloseInstancePublicPortsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse>()
                            .withMarshaller(new CloseInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(closeInstancePublicPortsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to a Lightsail instance in the same Availability Zone (e.g.,
     * <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the HTTP request to. For
     * more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     *
     * @param createDiskRequest
     * @return A Java Future containing the result of the CreateDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        try {

            HttpResponseHandler<CreateDiskResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDiskResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateDiskRequest, CreateDiskResponse>()
                    .withMarshaller(new CreateDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDiskRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk from a disk snapshot that can be attached to a Lightsail instance in the same
     * Availability Zone (e.g., <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the
     * HTTP request to. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(
            CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        try {

            HttpResponseHandler<CreateDiskFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDiskFromSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDiskFromSnapshotRequest, CreateDiskFromSnapshotResponse>()
                            .withMarshaller(new CreateDiskFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDiskFromSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     *
     * @param createDiskSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        try {

            HttpResponseHandler<CreateDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDiskSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateDiskSnapshotRequest, CreateDiskSnapshotResponse>()
                    .withMarshaller(new CreateDiskSnapshotRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createDiskSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        try {

            HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                    .withMarshaller(new CreateDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX
     * record.
     * </p>
     *
     * @param createDomainEntryRequest
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        try {

            HttpResponseHandler<CreateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDomainEntryResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateDomainEntryRequest, CreateDomainEntryResponse>()
                    .withMarshaller(new CreateDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDomainEntryRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     *
     * @param createInstanceSnapshotRequest
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        try {

            HttpResponseHandler<CreateInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateInstanceSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse>()
                            .withMarshaller(new CreateInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstanceSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param createInstancesRequest
     * @return A Java Future containing the result of the CreateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        try {

            HttpResponseHandler<CreateInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateInstancesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateInstancesRequest, CreateInstancesResponse>()
                    .withMarshaller(new CreateInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical
     * configuration.
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        try {

            HttpResponseHandler<CreateInstancesFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateInstancesFromSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse>()
                            .withMarshaller(new CreateInstancesFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstancesFromSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates sn SSH key pair.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        try {

            HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateKeyPairResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                    .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createKeyPairRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        try {

            HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                    .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the CreateLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(
            CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        try {

            HttpResponseHandler<CreateLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(
                            new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                            new CreateLoadBalancerTlsCertificateResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerTlsCertificateRequest, CreateLoadBalancerTlsCertificateResponse>()
                            .withMarshaller(new CreateLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoadBalancerTlsCertificateRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     *
     * @param deleteDiskRequest
     * @return A Java Future containing the result of the DeleteDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        try {

            HttpResponseHandler<DeleteDiskResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteDiskResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteDiskRequest, DeleteDiskResponse>()
                    .withMarshaller(new DeleteDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDiskRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     * @return A Java Future containing the result of the DeleteDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        try {

            HttpResponseHandler<DeleteDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteDiskSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteDiskSnapshotRequest, DeleteDiskSnapshotResponse>()
                    .withMarshaller(new DeleteDiskSnapshotRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteDiskSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        try {

            HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                    .withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     *
     * @param deleteDomainEntryRequest
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        try {

            HttpResponseHandler<DeleteDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteDomainEntryResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainEntryRequest, DeleteDomainEntryResponse>()
                    .withMarshaller(new DeleteDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainEntryRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        try {

            HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                    .withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        try {

            HttpResponseHandler<DeleteInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteInstanceSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse>()
                            .withMarshaller(new DeleteInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInstanceSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        try {

            HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteKeyPairResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                    .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteKeyPairRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        try {

            HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                    .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the DeleteLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(
            DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        try {

            HttpResponseHandler<DeleteLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(
                            new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                            new DeleteLoadBalancerTlsCertificateResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerTlsCertificateRequest, DeleteLoadBalancerTlsCertificateResponse>()
                            .withMarshaller(new DeleteLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLoadBalancerTlsCertificateRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     *
     * @param detachDiskRequest
     * @return A Java Future containing the result of the DetachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        try {

            HttpResponseHandler<DetachDiskResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DetachDiskResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DetachDiskRequest, DetachDiskResponse>()
                    .withMarshaller(new DetachDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachDiskRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     * @return A Java Future containing the result of the DetachInstancesFromLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(
            DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        try {

            HttpResponseHandler<DetachInstancesFromLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DetachInstancesFromLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DetachInstancesFromLoadBalancerRequest, DetachInstancesFromLoadBalancerResponse>()
                            .withMarshaller(new DetachInstancesFromLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachInstancesFromLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     *
     * @param detachStaticIpRequest
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        try {

            HttpResponseHandler<DetachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DetachStaticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DetachStaticIpRequest, DetachStaticIpResponse>()
                    .withMarshaller(new DetachStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachStaticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        try {

            HttpResponseHandler<DownloadDefaultKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DownloadDefaultKeyPairResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse>()
                            .withMarshaller(new DownloadDefaultKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(downloadDefaultKeyPairRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        try {

            HttpResponseHandler<GetActiveNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetActiveNamesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetActiveNamesRequest, GetActiveNamesResponse>()
                    .withMarshaller(new GetActiveNamesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getActiveNamesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     *
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        try {

            HttpResponseHandler<GetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetBlueprintsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetBlueprintsRequest, GetBlueprintsResponse>()
                    .withMarshaller(new GetBlueprintsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBlueprintsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        try {

            HttpResponseHandler<GetBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetBundlesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetBundlesRequest, GetBundlesResponse>()
                    .withMarshaller(new GetBundlesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBundlesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     *
     * @param getDiskRequest
     * @return A Java Future containing the result of the GetDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        try {

            HttpResponseHandler<GetDiskResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDiskResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDiskRequest, GetDiskResponse>()
                    .withMarshaller(new GetDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDiskRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     *
     * @param getDiskSnapshotRequest
     * @return A Java Future containing the result of the GetDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        try {

            HttpResponseHandler<GetDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDiskSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDiskSnapshotRequest, GetDiskSnapshotResponse>()
                    .withMarshaller(new GetDiskSnapshotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDiskSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disk snapshots, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDiskSnapshotsRequest
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        try {

            HttpResponseHandler<GetDiskSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDiskSnapshotsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDiskSnapshotsRequest, GetDiskSnapshotsResponse>()
                    .withMarshaller(new GetDiskSnapshotsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDiskSnapshotsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disks, you can paginate the output to make the list more manageable. You can
     * use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDisksRequest
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        try {

            HttpResponseHandler<GetDisksResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDisksResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDisksRequest, GetDisksResponse>()
                    .withMarshaller(new GetDisksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDisksRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        try {

            HttpResponseHandler<GetDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDomainRequest, GetDomainResponse>()
                    .withMarshaller(new GetDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        try {

            HttpResponseHandler<GetDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDomainsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDomainsRequest, GetDomainsResponse>()
                    .withMarshaller(new GetDomainsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     *
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        try {

            HttpResponseHandler<GetInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstanceRequest, GetInstanceResponse>()
                    .withMarshaller(new GetInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        try {

            HttpResponseHandler<GetInstanceAccessDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceAccessDetailsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse>()
                            .withMarshaller(new GetInstanceAccessDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceAccessDetailsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     *
     * @param getInstanceMetricDataRequest
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        try {

            HttpResponseHandler<GetInstanceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceMetricDataResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse>()
                    .withMarshaller(new GetInstanceMetricDataRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getInstanceMetricDataRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param getInstancePortStatesRequest
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            GetInstancePortStatesRequest getInstancePortStatesRequest) {
        try {

            HttpResponseHandler<GetInstancePortStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstancePortStatesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstancePortStatesRequest, GetInstancePortStatesResponse>()
                    .withMarshaller(new GetInstancePortStatesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getInstancePortStatesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     *
     * @param getInstanceSnapshotRequest
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        try {

            HttpResponseHandler<GetInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceSnapshotResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse>()
                    .withMarshaller(new GetInstanceSnapshotRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getInstanceSnapshotRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        try {

            HttpResponseHandler<GetInstanceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceSnapshotsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse>()
                    .withMarshaller(new GetInstanceSnapshotsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getInstanceSnapshotsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     *
     * @param getInstanceStateRequest
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        try {

            HttpResponseHandler<GetInstanceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstanceStateResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstanceStateRequest, GetInstanceStateResponse>()
                    .withMarshaller(new GetInstanceStateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceStateRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        try {

            HttpResponseHandler<GetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetInstancesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetInstancesRequest, GetInstancesResponse>()
                    .withMarshaller(new GetInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     *
     * @param getKeyPairRequest
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        try {

            HttpResponseHandler<GetKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetKeyPairResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetKeyPairRequest, GetKeyPairResponse>()
                    .withMarshaller(new GetKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getKeyPairRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        try {

            HttpResponseHandler<GetKeyPairsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetKeyPairsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetKeyPairsRequest, GetKeyPairsResponse>()
                    .withMarshaller(new GetKeyPairsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getKeyPairsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerRequest
     * @return A Java Future containing the result of the GetLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        try {

            HttpResponseHandler<GetLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetLoadBalancerRequest, GetLoadBalancerResponse>()
                    .withMarshaller(new GetLoadBalancerRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     * @return A Java Future containing the result of the GetLoadBalancerMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(
            GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        try {

            HttpResponseHandler<GetLoadBalancerMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetLoadBalancerMetricDataResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerMetricDataRequest, GetLoadBalancerMetricDataResponse>()
                            .withMarshaller(new GetLoadBalancerMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancerMetricDataRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     * @return A Java Future containing the result of the GetLoadBalancerTlsCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(
            GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        try {

            HttpResponseHandler<GetLoadBalancerTlsCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetLoadBalancerTlsCertificatesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerTlsCertificatesRequest, GetLoadBalancerTlsCertificatesResponse>()
                            .withMarshaller(new GetLoadBalancerTlsCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancerTlsCertificatesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <p>
     * If you are describing a long list of load balancers, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getLoadBalancersRequest
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        try {

            HttpResponseHandler<GetLoadBalancersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetLoadBalancersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetLoadBalancersRequest, GetLoadBalancersResponse>()
                    .withMarshaller(new GetLoadBalancersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLoadBalancersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     *
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        try {

            HttpResponseHandler<GetOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetOperationResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetOperationRequest, GetOperationResponse>()
                    .withMarshaller(new GetOperationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getOperationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        try {

            HttpResponseHandler<GetOperationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetOperationsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetOperationsRequest, GetOperationsResponse>()
                    .withMarshaller(new GetOperationsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getOperationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     *
     * @param getOperationsForResourceRequest
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) {
        try {

            HttpResponseHandler<GetOperationsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetOperationsForResourceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetOperationsForResourceRequest, GetOperationsForResourceResponse>()
                            .withMarshaller(new GetOperationsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOperationsForResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     *
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        try {

            HttpResponseHandler<GetRegionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetRegionsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetRegionsRequest, GetRegionsResponse>()
                    .withMarshaller(new GetRegionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRegionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     *
     * @param getStaticIpRequest
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        try {

            HttpResponseHandler<GetStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetStaticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetStaticIpRequest, GetStaticIpResponse>()
                    .withMarshaller(new GetStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStaticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        try {

            HttpResponseHandler<GetStaticIpsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetStaticIpsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetStaticIpsRequest, GetStaticIpsResponse>()
                    .withMarshaller(new GetStaticIpsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStaticIpsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     *
     * @param importKeyPairRequest
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        try {

            HttpResponseHandler<ImportKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ImportKeyPairResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                    .withMarshaller(new ImportKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importKeyPairRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        try {

            HttpResponseHandler<IsVpcPeeredResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new IsVpcPeeredResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<IsVpcPeeredRequest, IsVpcPeeredResponse>()
                    .withMarshaller(new IsVpcPeeredRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(isVpcPeeredRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     *
     * @param openInstancePublicPortsRequest
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        try {

            HttpResponseHandler<OpenInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new OpenInstancePublicPortsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse>()
                            .withMarshaller(new OpenInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(openInstancePublicPortsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        try {

            HttpResponseHandler<PeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new PeerVpcResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<PeerVpcRequest, PeerVpcResponse>()
                    .withMarshaller(new PeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(peerVpcRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     *
     * @param putInstancePublicPortsRequest
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        try {

            HttpResponseHandler<PutInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new PutInstancePublicPortsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse>()
                            .withMarshaller(new PutInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putInstancePublicPortsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new
     * public IP address. To use the same IP address after restarting, create a static IP address and attach it to the
     * instance.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        try {

            HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RebootInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                    .withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rebootInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     *
     * @param releaseStaticIpRequest
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        try {

            HttpResponseHandler<ReleaseStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ReleaseStaticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ReleaseStaticIpRequest, ReleaseStaticIpResponse>()
                    .withMarshaller(new ReleaseStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(releaseStaticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance
     * operation.
     * </p>
     *
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        try {

            HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StartInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                    .withMarshaller(new StartInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     *
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        try {

            HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StopInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                    .withMarshaller(new StopInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        try {

            HttpResponseHandler<UnpeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UnpeerVpcResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UnpeerVpcRequest, UnpeerVpcResponse>()
                    .withMarshaller(new UnpeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(unpeerVpcRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     *
     * @param updateDomainEntryRequest
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        try {

            HttpResponseHandler<UpdateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateDomainEntryResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateDomainEntryRequest, UpdateDomainEntryResponse>()
                    .withMarshaller(new UpdateDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDomainEntryRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     * @return A Java Future containing the result of the UpdateLoadBalancerAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(
            UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        try {

            HttpResponseHandler<UpdateLoadBalancerAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateLoadBalancerAttributeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLoadBalancerAttributeRequest, UpdateLoadBalancerAttributeResponse>()
                            .withMarshaller(new UpdateLoadBalancerAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateLoadBalancerAttributeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(supportsCbor)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.lightsail.model.LightsailException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("OperationFailureException").withModeledClass(
                                        OperationFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("UnauthenticatedException").withModeledClass(
                                        UnauthenticatedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(
                                        ServiceException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(
                                        AccessDeniedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(
                                        InvalidInputException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccountSetupInProgressException").withModeledClass(
                                        AccountSetupInProgressException.class)), AwsJsonProtocolMetadata.builder()
                        .protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
