/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Lightsail is the easiest way to get started with AWS for developers who just need virtual private servers.
 * Lightsail includes everything you need to launch your project quickly - a virtual machine, SSD-based storage, data
 * transfer, DNS management, and a static IP - for a low, predictable price. You manage those Lightsail servers through
 * the Lightsail console or by using the API or command-line interface (CLI).
 * </p>
 * <p>
 * For more information about Lightsail concepts and tasks, see the <a
 * href="https://lightsail.aws.amazon.com/ls/docs/all">Lightsail Dev Guide</a>.
 * </p>
 * <p>
 * To use the Lightsail API or the CLI, you will need to use AWS Identity and Access Management (IAM) to generate access
 * keys. For details about how to set this up, see the <a href=
 * "http://lightsail.aws.amazon.com/ls/docs/how-to/article/lightsail-how-to-set-up-access-keys-to-use-sdk-api-cli"
 * >Lightsail Dev Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LightsailAsyncClient extends SdkClient {
    String SERVICE_NAME = "lightsail";

    /**
     * Create a {@link LightsailAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LightsailAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LightsailAsyncClient}.
     */
    static LightsailAsyncClientBuilder builder() {
        return new DefaultLightsailAsyncClientBuilder();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     *
     * @param allocateStaticIpRequest
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateStaticIpRequest.Builder} avoiding the need
     * to create one manually via {@link AllocateStaticIpRequest#builder()}
     * </p>
     *
     * @param allocateStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link AllocateStaticIpRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(
            Consumer<AllocateStaticIpRequest.Builder> allocateStaticIpRequest) {
        return allocateStaticIp(AllocateStaticIpRequest.builder().applyMutation(allocateStaticIpRequest).build());
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     *
     * @param attachDiskRequest
     * @return A Java Future containing the result of the AttachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachDiskRequest.Builder} avoiding the need to
     * create one manually via {@link AttachDiskRequest#builder()}
     * </p>
     *
     * @param attachDiskRequest
     *        A {@link Consumer} that will call methods on {@link AttachDiskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachDiskResponse> attachDisk(Consumer<AttachDiskRequest.Builder> attachDiskRequest) {
        return attachDisk(AttachDiskRequest.builder().applyMutation(attachDiskRequest).build());
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     * @return A Java Future containing the result of the AttachInstancesToLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(
            AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInstancesToLoadBalancerRequest.Builder}
     * avoiding the need to create one manually via {@link AttachInstancesToLoadBalancerRequest#builder()}
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link AttachInstancesToLoadBalancerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AttachInstancesToLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(
            Consumer<AttachInstancesToLoadBalancerRequest.Builder> attachInstancesToLoadBalancerRequest) {
        return attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest.builder()
                .applyMutation(attachInstancesToLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> operation with
     * the non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(
            AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> operation with
     * the non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link AttachLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link AttachLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AttachLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(
            Consumer<AttachLoadBalancerTlsCertificateRequest.Builder> attachLoadBalancerTlsCertificateRequest) {
        return attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(attachLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     *
     * @param attachStaticIpRequest
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link AttachStaticIpRequest#builder()}
     * </p>
     *
     * @param attachStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link AttachStaticIpRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachStaticIpResponse> attachStaticIp(Consumer<AttachStaticIpRequest.Builder> attachStaticIpRequest) {
        return attachStaticIp(AttachStaticIpRequest.builder().applyMutation(attachStaticIpRequest).build());
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseInstancePublicPortsRequest.Builder} avoiding
     * the need to create one manually via {@link CloseInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link CloseInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            Consumer<CloseInstancePublicPortsRequest.Builder> closeInstancePublicPortsRequest) {
        return closeInstancePublicPorts(CloseInstancePublicPortsRequest.builder().applyMutation(closeInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to a Lightsail instance in the same Availability Zone (e.g.,
     * <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the HTTP request to. For
     * more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     *
     * @param createDiskRequest
     * @return A Java Future containing the result of the CreateDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to a Lightsail instance in the same Availability Zone (e.g.,
     * <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the HTTP request to. For
     * more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDiskRequest#builder()}
     * </p>
     *
     * @param createDiskRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDiskResponse> createDisk(Consumer<CreateDiskRequest.Builder> createDiskRequest) {
        return createDisk(CreateDiskRequest.builder().applyMutation(createDiskRequest).build());
    }

    /**
     * <p>
     * Creates a block storage disk from a disk snapshot that can be attached to a Lightsail instance in the same
     * Availability Zone (e.g., <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the
     * HTTP request to. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(
            CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block storage disk from a disk snapshot that can be attached to a Lightsail instance in the same
     * Availability Zone (e.g., <code>us-east-2a</code>). The disk is created in the regional endpoint that you send the
     * HTTP request to. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail"
     * >Regions and Availability Zones in Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDiskFromSnapshotRequest#builder()}
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskFromSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDiskFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(
            Consumer<CreateDiskFromSnapshotRequest.Builder> createDiskFromSnapshotRequest) {
        return createDiskFromSnapshot(CreateDiskFromSnapshotRequest.builder().applyMutation(createDiskFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     *
     * @param createDiskSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param createDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(
            Consumer<CreateDiskSnapshotRequest.Builder> createDiskSnapshotRequest) {
        return createDiskSnapshot(CreateDiskSnapshotRequest.builder().applyMutation(createDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX
     * record.
     * </p>
     *
     * @param createDomainEntryRequest
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX
     * record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainEntryRequest#builder()}
     * </p>
     *
     * @param createDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainEntryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDomainEntryResponse> createDomainEntry(
            Consumer<CreateDomainEntryRequest.Builder> createDomainEntryRequest) {
        return createDomainEntry(CreateDomainEntryRequest.builder().applyMutation(createDomainEntryRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     *
     * @param createInstanceSnapshotRequest
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param createInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            Consumer<CreateInstanceSnapshotRequest.Builder> createInstanceSnapshotRequest) {
        return createInstanceSnapshot(CreateInstanceSnapshotRequest.builder().applyMutation(createInstanceSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param createInstancesRequest
     * @return A Java Future containing the result of the CreateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInstancesRequest#builder()}
     * </p>
     *
     * @param createInstancesRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstancesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstancesResponse> createInstances(
            Consumer<CreateInstancesRequest.Builder> createInstancesRequest) {
        return createInstances(CreateInstancesRequest.builder().applyMutation(createInstancesRequest).build());
    }

    /**
     * <p>
     * Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical
     * configuration.
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstancesFromSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInstancesFromSnapshotRequest#builder()}
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstancesFromSnapshotRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            Consumer<CreateInstancesFromSnapshotRequest.Builder> createInstancesFromSnapshotRequest) {
        return createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest.builder()
                .applyMutation(createInstancesFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates sn SSH key pair.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates sn SSH key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyPairRequest#builder()}
     * </p>
     *
     * @param createKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyPairResponse> createKeyPair(Consumer<CreateKeyPairRequest.Builder> createKeyPairRequest) {
        return createKeyPair(CreateKeyPairRequest.builder().applyMutation(createKeyPairRequest).build());
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoadBalancerRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoadBalancerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(
            Consumer<CreateLoadBalancerRequest.Builder> createLoadBalancerRequest) {
        return createLoadBalancer(CreateLoadBalancerRequest.builder().applyMutation(createLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the CreateLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(
            CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(
            Consumer<CreateLoadBalancerTlsCertificateRequest.Builder> createLoadBalancerTlsCertificateRequest) {
        return createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(createLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     *
     * @param deleteDiskRequest
     * @return A Java Future containing the result of the DeleteDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDiskRequest#builder()}
     * </p>
     *
     * @param deleteDiskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDiskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDiskResponse> deleteDisk(Consumer<DeleteDiskRequest.Builder> deleteDiskRequest) {
        return deleteDisk(DeleteDiskRequest.builder().applyMutation(deleteDiskRequest).build());
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     * @return A Java Future containing the result of the DeleteDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiskSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDiskSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(
            Consumer<DeleteDiskSnapshotRequest.Builder> deleteDiskSnapshotRequest) {
        return deleteDiskSnapshot(DeleteDiskSnapshotRequest.builder().applyMutation(deleteDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     *
     * @param deleteDomainEntryRequest
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainEntryRequest#builder()}
     * </p>
     *
     * @param deleteDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainEntryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(
            Consumer<DeleteDomainEntryRequest.Builder> deleteDomainEntryRequest) {
        return deleteDomainEntry(DeleteDomainEntryRequest.builder().applyMutation(deleteDomainEntryRequest).build());
    }

    /**
     * <p>
     * Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest) {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            Consumer<DeleteInstanceSnapshotRequest.Builder> deleteInstanceSnapshotRequest) {
        return deleteInstanceSnapshot(DeleteInstanceSnapshotRequest.builder().applyMutation(deleteInstanceSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyPairRequest#builder()}
     * </p>
     *
     * @param deleteKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(Consumer<DeleteKeyPairRequest.Builder> deleteKeyPairRequest) {
        return deleteKeyPair(DeleteKeyPairRequest.builder().applyMutation(deleteKeyPairRequest).build());
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoadBalancerRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoadBalancerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(
            Consumer<DeleteLoadBalancerRequest.Builder> deleteLoadBalancerRequest) {
        return deleteLoadBalancer(DeleteLoadBalancerRequest.builder().applyMutation(deleteLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the DeleteLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(
            DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(
            Consumer<DeleteLoadBalancerTlsCertificateRequest.Builder> deleteLoadBalancerTlsCertificateRequest) {
        return deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(deleteLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     *
     * @param detachDiskRequest
     * @return A Java Future containing the result of the DetachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachDiskRequest.Builder} avoiding the need to
     * create one manually via {@link DetachDiskRequest#builder()}
     * </p>
     *
     * @param detachDiskRequest
     *        A {@link Consumer} that will call methods on {@link DetachDiskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachDiskResponse> detachDisk(Consumer<DetachDiskRequest.Builder> detachDiskRequest) {
        return detachDisk(DetachDiskRequest.builder().applyMutation(detachDiskRequest).build());
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     * @return A Java Future containing the result of the DetachInstancesFromLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(
            DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachInstancesFromLoadBalancerRequest.Builder}
     * avoiding the need to create one manually via {@link DetachInstancesFromLoadBalancerRequest#builder()}
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link DetachInstancesFromLoadBalancerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DetachInstancesFromLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(
            Consumer<DetachInstancesFromLoadBalancerRequest.Builder> detachInstancesFromLoadBalancerRequest) {
        return detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest.builder()
                .applyMutation(detachInstancesFromLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     *
     * @param detachStaticIpRequest
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link DetachStaticIpRequest#builder()}
     * </p>
     *
     * @param detachStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link DetachStaticIpRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachStaticIpResponse> detachStaticIp(Consumer<DetachStaticIpRequest.Builder> detachStaticIpRequest) {
        return detachStaticIp(DetachStaticIpRequest.builder().applyMutation(detachStaticIpRequest).build());
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DownloadDefaultKeyPairRequest.Builder} avoiding the
     * need to create one manually via {@link DownloadDefaultKeyPairRequest#builder()}
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link DownloadDefaultKeyPairRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            Consumer<DownloadDefaultKeyPairRequest.Builder> downloadDefaultKeyPairRequest) {
        return downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.builder().applyMutation(downloadDefaultKeyPairRequest)
                .build());
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair() {
        return downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.builder().build());
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActiveNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetActiveNamesRequest#builder()}
     * </p>
     *
     * @param getActiveNamesRequest
     *        A {@link Consumer} that will call methods on {@link GetActiveNamesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActiveNamesResponse> getActiveNames(Consumer<GetActiveNamesRequest.Builder> getActiveNamesRequest) {
        return getActiveNames(GetActiveNamesRequest.builder().applyMutation(getActiveNamesRequest).build());
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActiveNamesResponse> getActiveNames() {
        return getActiveNames(GetActiveNamesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     *
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlueprintsRequest#builder()}
     * </p>
     *
     * @param getBlueprintsRequest
     *        A {@link Consumer} that will call methods on {@link GetBlueprintsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintsResponse> getBlueprints(Consumer<GetBlueprintsRequest.Builder> getBlueprintsRequest) {
        return getBlueprints(GetBlueprintsRequest.builder().applyMutation(getBlueprintsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     *
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintsResponse> getBlueprints() {
        return getBlueprints(GetBlueprintsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link GetBundlesRequest#builder()}
     * </p>
     *
     * @param getBundlesRequest
     *        A {@link Consumer} that will call methods on {@link GetBundlesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBundlesResponse> getBundles(Consumer<GetBundlesRequest.Builder> getBundlesRequest) {
        return getBundles(GetBundlesRequest.builder().applyMutation(getBundlesRequest).build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBundlesResponse> getBundles() {
        return getBundles(GetBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     *
     * @param getDiskRequest
     * @return A Java Future containing the result of the GetDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskRequest.Builder} avoiding the need to create
     * one manually via {@link GetDiskRequest#builder()}
     * </p>
     *
     * @param getDiskRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskResponse> getDisk(Consumer<GetDiskRequest.Builder> getDiskRequest) {
        return getDisk(GetDiskRequest.builder().applyMutation(getDiskRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     *
     * @param getDiskSnapshotRequest
     * @return A Java Future containing the result of the GetDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link GetDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param getDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(
            Consumer<GetDiskSnapshotRequest.Builder> getDiskSnapshotRequest) {
        return getDiskSnapshot(GetDiskSnapshotRequest.builder().applyMutation(getDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disk snapshots, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDiskSnapshotsRequest
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disk snapshots, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDiskSnapshotsRequest#builder()}
     * </p>
     *
     * @param getDiskSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(
            Consumer<GetDiskSnapshotsRequest.Builder> getDiskSnapshotsRequest) {
        return getDiskSnapshots(GetDiskSnapshotsRequest.builder().applyMutation(getDiskSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disk snapshots, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots() {
        return getDiskSnapshots(GetDiskSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disks, you can paginate the output to make the list more manageable. You can
     * use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDisksRequest
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disks, you can paginate the output to make the list more manageable. You can
     * use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDisksRequest.Builder} avoiding the need to
     * create one manually via {@link GetDisksRequest#builder()}
     * </p>
     *
     * @param getDisksRequest
     *        A {@link Consumer} that will call methods on {@link GetDisksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDisksResponse> getDisks(Consumer<GetDisksRequest.Builder> getDisksRequest) {
        return getDisks(GetDisksRequest.builder().applyMutation(getDisksRequest).build());
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disks, you can paginate the output to make the list more manageable. You can
     * use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDisksResponse> getDisks() {
        return getDisks(GetDisksRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainsRequest#builder()}
     * </p>
     *
     * @param getDomainsRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainsResponse> getDomains(Consumer<GetDomainsRequest.Builder> getDomainsRequest) {
        return getDomains(GetDomainsRequest.builder().applyMutation(getDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainsResponse> getDomains() {
        return getDomains(GetDomainsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     *
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstanceRequest#builder()}
     * </p>
     *
     * @param getInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) {
        return getInstance(GetInstanceRequest.builder().applyMutation(getInstanceRequest).build());
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceAccessDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetInstanceAccessDetailsRequest#builder()}
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceAccessDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            Consumer<GetInstanceAccessDetailsRequest.Builder> getInstanceAccessDetailsRequest) {
        return getInstanceAccessDetails(GetInstanceAccessDetailsRequest.builder().applyMutation(getInstanceAccessDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     *
     * @param getInstanceMetricDataRequest
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceMetricDataRequest#builder()}
     * </p>
     *
     * @param getInstanceMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceMetricDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            Consumer<GetInstanceMetricDataRequest.Builder> getInstanceMetricDataRequest) {
        return getInstanceMetricData(GetInstanceMetricDataRequest.builder().applyMutation(getInstanceMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param getInstancePortStatesRequest
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            GetInstancePortStatesRequest getInstancePortStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstancePortStatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstancePortStatesRequest#builder()}
     * </p>
     *
     * @param getInstancePortStatesRequest
     *        A {@link Consumer} that will call methods on {@link GetInstancePortStatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            Consumer<GetInstancePortStatesRequest.Builder> getInstancePortStatesRequest) {
        return getInstancePortStates(GetInstancePortStatesRequest.builder().applyMutation(getInstancePortStatesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     *
     * @param getInstanceSnapshotRequest
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param getInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            Consumer<GetInstanceSnapshotRequest.Builder> getInstanceSnapshotRequest) {
        return getInstanceSnapshot(GetInstanceSnapshotRequest.builder().applyMutation(getInstanceSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceSnapshotsRequest#builder()}
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            Consumer<GetInstanceSnapshotsRequest.Builder> getInstanceSnapshotsRequest) {
        return getInstanceSnapshots(GetInstanceSnapshotsRequest.builder().applyMutation(getInstanceSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots() {
        return getInstanceSnapshots(GetInstanceSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     *
     * @param getInstanceStateRequest
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetInstanceStateRequest#builder()}
     * </p>
     *
     * @param getInstanceStateRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceStateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceStateResponse> getInstanceState(
            Consumer<GetInstanceStateRequest.Builder> getInstanceStateRequest) {
        return getInstanceState(GetInstanceStateRequest.builder().applyMutation(getInstanceStateRequest).build());
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstancesRequest#builder()}
     * </p>
     *
     * @param getInstancesRequest
     *        A {@link Consumer} that will call methods on {@link GetInstancesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstancesResponse> getInstances(Consumer<GetInstancesRequest.Builder> getInstancesRequest) {
        return getInstances(GetInstancesRequest.builder().applyMutation(getInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstancesResponse> getInstances() {
        return getInstances(GetInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     *
     * @param getKeyPairRequest
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyPairRequest#builder()}
     * </p>
     *
     * @param getKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyPairResponse> getKeyPair(Consumer<GetKeyPairRequest.Builder> getKeyPairRequest) {
        return getKeyPair(GetKeyPairRequest.builder().applyMutation(getKeyPairRequest).build());
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyPairsRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyPairsRequest#builder()}
     * </p>
     *
     * @param getKeyPairsRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyPairsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyPairsResponse> getKeyPairs(Consumer<GetKeyPairsRequest.Builder> getKeyPairsRequest) {
        return getKeyPairs(GetKeyPairsRequest.builder().applyMutation(getKeyPairsRequest).build());
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyPairsResponse> getKeyPairs() {
        return getKeyPairs(GetKeyPairsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerRequest
     * @return A Java Future containing the result of the GetLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoadBalancerRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(
            Consumer<GetLoadBalancerRequest.Builder> getLoadBalancerRequest) {
        return getLoadBalancer(GetLoadBalancerRequest.builder().applyMutation(getLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     * @return A Java Future containing the result of the GetLoadBalancerMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(
            GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerMetricDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoadBalancerMetricDataRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerMetricDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoadBalancerMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(
            Consumer<GetLoadBalancerMetricDataRequest.Builder> getLoadBalancerMetricDataRequest) {
        return getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest.builder()
                .applyMutation(getLoadBalancerMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     * @return A Java Future containing the result of the GetLoadBalancerTlsCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(
            GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerTlsCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link GetLoadBalancerTlsCertificatesRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerTlsCertificatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLoadBalancerTlsCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(
            Consumer<GetLoadBalancerTlsCertificatesRequest.Builder> getLoadBalancerTlsCertificatesRequest) {
        return getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest.builder()
                .applyMutation(getLoadBalancerTlsCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <p>
     * If you are describing a long list of load balancers, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getLoadBalancersRequest
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <p>
     * If you are describing a long list of load balancers, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancersRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoadBalancersRequest#builder()}
     * </p>
     *
     * @param getLoadBalancersRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(
            Consumer<GetLoadBalancersRequest.Builder> getLoadBalancersRequest) {
        return getLoadBalancers(GetLoadBalancersRequest.builder().applyMutation(getLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <p>
     * If you are describing a long list of load balancers, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoadBalancersResponse> getLoadBalancers() {
        return getLoadBalancers(GetLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     *
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationRequest#builder()}
     * </p>
     *
     * @param getOperationRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOperationResponse> getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) {
        return getOperation(GetOperationRequest.builder().applyMutation(getOperationRequest).build());
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationsRequest#builder()}
     * </p>
     *
     * @param getOperationsRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOperationsResponse> getOperations(Consumer<GetOperationsRequest.Builder> getOperationsRequest) {
        return getOperations(GetOperationsRequest.builder().applyMutation(getOperationsRequest).build());
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOperationsResponse> getOperations() {
        return getOperations(GetOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     *
     * @param getOperationsForResourceRequest
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationsForResourceRequest.Builder} avoiding
     * the need to create one manually via {@link GetOperationsForResourceRequest#builder()}
     * </p>
     *
     * @param getOperationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            Consumer<GetOperationsForResourceRequest.Builder> getOperationsForResourceRequest) {
        return getOperationsForResource(GetOperationsForResourceRequest.builder().applyMutation(getOperationsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     *
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetRegionsRequest#builder()}
     * </p>
     *
     * @param getRegionsRequest
     *        A {@link Consumer} that will call methods on {@link GetRegionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegionsResponse> getRegions(Consumer<GetRegionsRequest.Builder> getRegionsRequest) {
        return getRegions(GetRegionsRequest.builder().applyMutation(getRegionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     *
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegionsResponse> getRegions() {
        return getRegions(GetRegionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     *
     * @param getStaticIpRequest
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticIpRequest#builder()}
     * </p>
     *
     * @param getStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link GetStaticIpRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticIpResponse> getStaticIp(Consumer<GetStaticIpRequest.Builder> getStaticIpRequest) {
        return getStaticIp(GetStaticIpRequest.builder().applyMutation(getStaticIpRequest).build());
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticIpsRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticIpsRequest#builder()}
     * </p>
     *
     * @param getStaticIpsRequest
     *        A {@link Consumer} that will call methods on {@link GetStaticIpsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticIpsResponse> getStaticIps(Consumer<GetStaticIpsRequest.Builder> getStaticIpsRequest) {
        return getStaticIps(GetStaticIpsRequest.builder().applyMutation(getStaticIpsRequest).build());
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticIpsResponse> getStaticIps() {
        return getStaticIps(GetStaticIpsRequest.builder().build());
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     *
     * @param importKeyPairRequest
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link ImportKeyPairRequest#builder()}
     * </p>
     *
     * @param importKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link ImportKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportKeyPairResponse> importKeyPair(Consumer<ImportKeyPairRequest.Builder> importKeyPairRequest) {
        return importKeyPair(ImportKeyPairRequest.builder().applyMutation(importKeyPairRequest).build());
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IsVpcPeeredRequest.Builder} avoiding the need to
     * create one manually via {@link IsVpcPeeredRequest#builder()}
     * </p>
     *
     * @param isVpcPeeredRequest
     *        A {@link Consumer} that will call methods on {@link IsVpcPeeredRequest.Builder} to create a request.
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<IsVpcPeeredResponse> isVpcPeered(Consumer<IsVpcPeeredRequest.Builder> isVpcPeeredRequest) {
        return isVpcPeered(IsVpcPeeredRequest.builder().applyMutation(isVpcPeeredRequest).build());
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<IsVpcPeeredResponse> isVpcPeered() {
        return isVpcPeered(IsVpcPeeredRequest.builder().build());
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     *
     * @param openInstancePublicPortsRequest
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OpenInstancePublicPortsRequest.Builder} avoiding
     * the need to create one manually via {@link OpenInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param openInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link OpenInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            Consumer<OpenInstancePublicPortsRequest.Builder> openInstancePublicPortsRequest) {
        return openInstancePublicPorts(OpenInstancePublicPortsRequest.builder().applyMutation(openInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PeerVpcRequest.Builder} avoiding the need to create
     * one manually via {@link PeerVpcRequest#builder()}
     * </p>
     *
     * @param peerVpcRequest
     *        A {@link Consumer} that will call methods on {@link PeerVpcRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PeerVpcResponse> peerVpc(Consumer<PeerVpcRequest.Builder> peerVpcRequest) {
        return peerVpc(PeerVpcRequest.builder().applyMutation(peerVpcRequest).build());
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PeerVpcResponse> peerVpc() {
        return peerVpc(PeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     *
     * @param putInstancePublicPortsRequest
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInstancePublicPortsRequest.Builder} avoiding the
     * need to create one manually via {@link PutInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param putInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link PutInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            Consumer<PutInstancePublicPortsRequest.Builder> putInstancePublicPortsRequest) {
        return putInstancePublicPorts(PutInstancePublicPortsRequest.builder().applyMutation(putInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new
     * public IP address. To use the same IP address after restarting, create a static IP address and attach it to the
     * instance.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new
     * public IP address. To use the same IP address after restarting, create a static IP address and attach it to the
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link RebootInstanceRequest#builder()}
     * </p>
     *
     * @param rebootInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RebootInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootInstanceResponse> rebootInstance(Consumer<RebootInstanceRequest.Builder> rebootInstanceRequest) {
        return rebootInstance(RebootInstanceRequest.builder().applyMutation(rebootInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     *
     * @param releaseStaticIpRequest
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleaseStaticIpRequest.Builder} avoiding the need
     * to create one manually via {@link ReleaseStaticIpRequest#builder()}
     * </p>
     *
     * @param releaseStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link ReleaseStaticIpRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(
            Consumer<ReleaseStaticIpRequest.Builder> releaseStaticIpRequest) {
        return releaseStaticIp(ReleaseStaticIpRequest.builder().applyMutation(releaseStaticIpRequest).build());
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance
     * operation.
     * </p>
     *
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link StartInstanceRequest#builder()}
     * </p>
     *
     * @param startInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StartInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartInstanceResponse> startInstance(Consumer<StartInstanceRequest.Builder> startInstanceRequest) {
        return startInstance(StartInstanceRequest.builder().applyMutation(startInstanceRequest).build());
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     *
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link StopInstanceRequest#builder()}
     * </p>
     *
     * @param stopInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StopInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopInstanceResponse> stopInstance(Consumer<StopInstanceRequest.Builder> stopInstanceRequest) {
        return stopInstance(StopInstanceRequest.builder().applyMutation(stopInstanceRequest).build());
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnpeerVpcRequest.Builder} avoiding the need to
     * create one manually via {@link UnpeerVpcRequest#builder()}
     * </p>
     *
     * @param unpeerVpcRequest
     *        A {@link Consumer} that will call methods on {@link UnpeerVpcRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnpeerVpcResponse> unpeerVpc(Consumer<UnpeerVpcRequest.Builder> unpeerVpcRequest) {
        return unpeerVpc(UnpeerVpcRequest.builder().applyMutation(unpeerVpcRequest).build());
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnpeerVpcResponse> unpeerVpc() {
        return unpeerVpc(UnpeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     *
     * @param updateDomainEntryRequest
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainEntryRequest#builder()}
     * </p>
     *
     * @param updateDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainEntryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(
            Consumer<UpdateDomainEntryRequest.Builder> updateDomainEntryRequest) {
        return updateDomainEntry(UpdateDomainEntryRequest.builder().applyMutation(updateDomainEntryRequest).build());
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     * @return A Java Future containing the result of the UpdateLoadBalancerAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(
            UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoadBalancerAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLoadBalancerAttributeRequest#builder()}
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoadBalancerAttributeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateLoadBalancerAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(
            Consumer<UpdateLoadBalancerAttributeRequest.Builder> updateLoadBalancerAttributeRequest) {
        return updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest.builder()
                .applyMutation(updateLoadBalancerAttributeRequest).build());
    }
}
