/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.AvailabilityZoneMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements StructuredPojo, ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private final String zoneName;

    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
     * </p>
     * 
     * @return The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
     */
    public String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * 
     * @return The state of the Availability Zone.
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(zoneName(), other.zoneName()) && Objects.equals(state(), other.state());
    }

    @Override
    public String toString() {
        return ToString.builder("AvailabilityZone").add("ZoneName", zoneName()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "zoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AvailabilityZoneMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String zoneName;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            zoneName(model.zoneName);
            state(model.state);
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }
}
