/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyPairResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateKeyPairResponse.Builder, CreateKeyPairResponse> {
    private final KeyPair keyPair;

    private final String publicKeyBase64;

    private final String privateKeyBase64;

    private final Operation operation;

    private CreateKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyPair = builder.keyPair;
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the new key pair you just created.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the new key pair you just created.
     */
    public KeyPair keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * A base64-encoded public key of the <code>ssh-rsa</code> type.
     * </p>
     * 
     * @return A base64-encoded public key of the <code>ssh-rsa</code> type.
     */
    public String publicKeyBase64() {
        return publicKeyBase64;
    }

    /**
     * <p>
     * A base64-encoded RSA private key.
     * </p>
     * 
     * @return A base64-encoded RSA private key.
     */
    public String privateKeyBase64() {
        return privateKeyBase64;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your create key pair request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your create key pair request.
     */
    public Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse) obj;
        return Objects.equals(keyPair(), other.keyPair()) && Objects.equals(publicKeyBase64(), other.publicKeyBase64())
                && Objects.equals(privateKeyBase64(), other.privateKeyBase64()) && Objects.equals(operation(), other.operation());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateKeyPairResponse").add("KeyPair", keyPair()).add("PublicKeyBase64", publicKeyBase64())
                .add("PrivateKeyBase64", privateKeyBase64()).add("Operation", operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "publicKeyBase64":
            return Optional.ofNullable(clazz.cast(publicKeyBase64()));
        case "privateKeyBase64":
            return Optional.ofNullable(clazz.cast(privateKeyBase64()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, CreateKeyPairResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the new key pair you just created.
         * </p>
         * 
         * @param keyPair
         *        An array of key-value pairs containing information about the new key pair you just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);

        /**
         * <p>
         * An array of key-value pairs containing information about the new key pair you just created.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyPair.Builder} avoiding the need to create one
         * manually via {@link KeyPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPair.Builder#build()} is called immediately and its result is
         * passed to {@link #keyPair(KeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link KeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(KeyPair)
         */
        default Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return keyPair(KeyPair.builder().applyMutation(keyPair).build());
        }

        /**
         * <p>
         * A base64-encoded public key of the <code>ssh-rsa</code> type.
         * </p>
         * 
         * @param publicKeyBase64
         *        A base64-encoded public key of the <code>ssh-rsa</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyBase64(String publicKeyBase64);

        /**
         * <p>
         * A base64-encoded RSA private key.
         * </p>
         * 
         * @param privateKeyBase64
         *        A base64-encoded RSA private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyBase64(String privateKeyBase64);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your create key pair request.
         * </p>
         * 
         * @param operation
         *        An array of key-value pairs containing information about the results of your create key pair request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your create key pair request.
         * </p>
         * This is a convenience that creates an instance of the {@link Operation.Builder} avoiding the need to create
         * one manually via {@link Operation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private KeyPair keyPair;

        private String publicKeyBase64;

        private String privateKeyBase64;

        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            super(model);
            keyPair(model.keyPair);
            publicKeyBase64(model.publicKeyBase64);
            privateKeyBase64(model.privateKeyBase64);
            operation(model.operation);
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        public final String getPublicKeyBase64() {
            return publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public final String getPrivateKeyBase64() {
            return privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }
    }
}
