/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerTlsCertificateResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateLoadBalancerTlsCertificateResponse.Builder, CreateLoadBalancerTlsCertificateResponse> {
    private final List<Operation> operations;

    private CreateLoadBalancerTlsCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
    }

    /**
     * <p>
     * An object containing information about the API operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing information about the API operations.
     */
    public List<Operation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerTlsCertificateResponse)) {
            return false;
        }
        CreateLoadBalancerTlsCertificateResponse other = (CreateLoadBalancerTlsCertificateResponse) obj;
        return Objects.equals(operations(), other.operations());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateLoadBalancerTlsCertificateResponse").add("Operations", operations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder,
            CopyableBuilder<Builder, CreateLoadBalancerTlsCertificateResponse> {
        /**
         * <p>
         * An object containing information about the API operations.
         * </p>
         * 
         * @param operations
         *        An object containing information about the API operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An object containing information about the API operations.
         * </p>
         * 
         * @param operations
         *        An object containing information about the API operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * An object containing information about the API operations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Operation>.Builder} avoiding the need to
         * create one manually via {@link List<Operation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Operation>.Builder#build()} is called immediately and its
         * result is passed to {@link #operations(List<Operation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on {@link List<Operation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(List<Operation>)
         */
        Builder operations(Consumer<Operation.Builder>... operations);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerTlsCertificateResponse model) {
            super(model);
            operations(model.operations);
        }

        public final Collection<Operation.Builder> getOperations() {
            return operations != null ? operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> Operation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public CreateLoadBalancerTlsCertificateResponse build() {
            return new CreateLoadBalancerTlsCertificateResponse(this);
        }
    }
}
