/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLoadBalancerTlsCertificateRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteLoadBalancerTlsCertificateRequest.Builder, DeleteLoadBalancerTlsCertificateRequest> {
    private final String loadBalancerName;

    private final String certificateName;

    private final Boolean force;

    private DeleteLoadBalancerTlsCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.certificateName = builder.certificateName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The load balancer name.
     * </p>
     * 
     * @return The load balancer name.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The SSL/TLS certificate name.
     * </p>
     * 
     * @return The SSL/TLS certificate name.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * When <code>true</code>, forces the deletion of an SSL/TLS certificate.
     * </p>
     * <p>
     * There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The force
     * parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the load
     * balancer.
     * </p>
     * 
     * @return When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
     *         <p>
     *         There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The
     *         force parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the
     *         load balancer.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerTlsCertificateRequest)) {
            return false;
        }
        DeleteLoadBalancerTlsCertificateRequest other = (DeleteLoadBalancerTlsCertificateRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(certificateName(), other.certificateName()) && Objects.equals(force(), other.force());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteLoadBalancerTlsCertificateRequest").add("LoadBalancerName", loadBalancerName())
                .add("CertificateName", certificateName()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, DeleteLoadBalancerTlsCertificateRequest> {
        /**
         * <p>
         * The load balancer name.
         * </p>
         * 
         * @param loadBalancerName
         *        The load balancer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The SSL/TLS certificate name.
         * </p>
         * 
         * @param certificateName
         *        The SSL/TLS certificate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * When <code>true</code>, forces the deletion of an SSL/TLS certificate.
         * </p>
         * <p>
         * There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The
         * force parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the
         * load balancer.
         * </p>
         * 
         * @param force
         *        When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
         *        <p>
         *        There can be two certificates associated with a Lightsail load balancer: the primary and the backup.
         *        The force parameter is required when the primary SSL/TLS certificate is in use by an instance attached
         *        to the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String certificateName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerTlsCertificateRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            certificateName(model.certificateName);
            force(model.force);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLoadBalancerTlsCertificateRequest build() {
            return new DeleteLoadBalancerTlsCertificateRequest(this);
        }
    }
}
