/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetBlueprintsRequest.Builder, GetBlueprintsRequest> {
    private final Boolean includeInactive;

    private final String pageToken;

    private GetBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.includeInactive = builder.includeInactive;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * A Boolean value indicating whether to include inactive results in your request.
     * </p>
     * 
     * @return A Boolean value indicating whether to include inactive results in your request.
     */
    public Boolean includeInactive() {
        return includeInactive;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get blueprints request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get blueprints request.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeInactive());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsRequest)) {
            return false;
        }
        GetBlueprintsRequest other = (GetBlueprintsRequest) obj;
        return Objects.equals(includeInactive(), other.includeInactive()) && Objects.equals(pageToken(), other.pageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBlueprintsRequest").add("IncludeInactive", includeInactive()).add("PageToken", pageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeInactive":
            return Optional.ofNullable(clazz.cast(includeInactive()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, GetBlueprintsRequest> {
        /**
         * <p>
         * A Boolean value indicating whether to include inactive results in your request.
         * </p>
         * 
         * @param includeInactive
         *        A Boolean value indicating whether to include inactive results in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInactive(Boolean includeInactive);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get blueprints request.
         * </p>
         * 
         * @param pageToken
         *        A token used for advancing to the next page of results from your get blueprints request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private Boolean includeInactive;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsRequest model) {
            super(model);
            includeInactive(model.includeInactive);
            pageToken(model.pageToken);
        }

        public final Boolean getIncludeInactive() {
            return includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintsRequest build() {
            return new GetBlueprintsRequest(this);
        }
    }
}
