/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiskSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<GetDiskSnapshotRequest.Builder, GetDiskSnapshotRequest> {
    private final String diskSnapshotName;

    private GetDiskSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskSnapshotName = builder.diskSnapshotName;
    }

    /**
     * <p>
     * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     * </p>
     * 
     * @return The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     */
    public String diskSnapshotName() {
        return diskSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotRequest)) {
            return false;
        }
        GetDiskSnapshotRequest other = (GetDiskSnapshotRequest) obj;
        return Objects.equals(diskSnapshotName(), other.diskSnapshotName());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDiskSnapshotRequest").add("DiskSnapshotName", diskSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskSnapshotName":
            return Optional.ofNullable(clazz.cast(diskSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, GetDiskSnapshotRequest> {
        /**
         * <p>
         * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * </p>
         * 
         * @param diskSnapshotName
         *        The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotName(String diskSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotRequest model) {
            super(model);
            diskSnapshotName(model.diskSnapshotName);
        }

        public final String getDiskSnapshotName() {
            return diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDiskSnapshotRequest build() {
            return new GetDiskSnapshotRequest(this);
        }
    }
}
