/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDomainsResponse.Builder, GetDomainsResponse> {
    private final List<Domain> domains;

    private final String nextPageToken;

    private GetDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domains = builder.domains;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about each of the domain entries in the user's account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about each of the domain entries in the user's
     *         account.
     */
    public List<Domain> domains() {
        return domains;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get active names request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get active names request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domains());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainsResponse)) {
            return false;
        }
        GetDomainsResponse other = (GetDomainsResponse) obj;
        return Objects.equals(domains(), other.domains()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDomainsResponse").add("Domains", domains()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetDomainsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about each of the domain entries in the user's account.
         * </p>
         * 
         * @param domains
         *        An array of key-value pairs containing information about each of the domain entries in the user's
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<Domain> domains);

        /**
         * <p>
         * An array of key-value pairs containing information about each of the domain entries in the user's account.
         * </p>
         * 
         * @param domains
         *        An array of key-value pairs containing information about each of the domain entries in the user's
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Domain... domains);

        /**
         * <p>
         * An array of key-value pairs containing information about each of the domain entries in the user's account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Domain>.Builder} avoiding the need to
         * create one manually via {@link List<Domain>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Domain>.Builder#build()} is called immediately and its
         * result is passed to {@link #domains(List<Domain>)}.
         * 
         * @param domains
         *        a consumer that will call methods on {@link List<Domain>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(List<Domain>)
         */
        Builder domains(Consumer<Domain.Builder>... domains);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get active names request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Domain> domains = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainsResponse model) {
            super(model);
            domains(model.domains);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Domain.Builder> getDomains() {
            return domains != null ? domains.stream().map(Domain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<Domain.Builder>... domains) {
            domains(Stream.of(domains).map(c -> Domain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomains(Collection<Domain.BuilderImpl> domains) {
            this.domains = DomainListCopier.copyFromBuilder(domains);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDomainsResponse build() {
            return new GetDomainsResponse(this);
        }
    }
}
