/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancersResponse extends LightsailResponse implements
        ToCopyableBuilder<GetLoadBalancersResponse.Builder, GetLoadBalancersResponse> {
    private final List<LoadBalancer> loadBalancers;

    private final String nextPageToken;

    private GetLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancers = builder.loadBalancers;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of LoadBalancer objects describing your load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of LoadBalancer objects describing your load balancers.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your GetLoadBalancers request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your GetLoadBalancers request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancersResponse)) {
            return false;
        }
        GetLoadBalancersResponse other = (GetLoadBalancersResponse) obj;
        return Objects.equals(loadBalancers(), other.loadBalancers()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLoadBalancersResponse").add("LoadBalancers", loadBalancers())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetLoadBalancersResponse> {
        /**
         * <p>
         * An array of LoadBalancer objects describing your load balancers.
         * </p>
         * 
         * @param loadBalancers
         *        An array of LoadBalancer objects describing your load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * An array of LoadBalancer objects describing your load balancers.
         * </p>
         * 
         * @param loadBalancers
         *        An array of LoadBalancer objects describing your load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * An array of LoadBalancer objects describing your load balancers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * A token used for advancing to the next page of results from your GetLoadBalancers request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your GetLoadBalancers request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancersResponse model) {
            super(model);
            loadBalancers(model.loadBalancers);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copyFromBuilder(loadBalancers);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetLoadBalancersResponse build() {
            return new GetLoadBalancersResponse(this);
        }
    }
}
